import { createRequire } from "node:module";
import type { StorybookConfig } from "@storybook/react-vite";

import { join, dirname } from "path";
import frontCommerceConfig from "../front-commerce.config";

const require = createRequire(import.meta.url);

const extensionThemeStories = frontCommerceConfig.extensions
  .filter((ext) => ext.theme)
  .map((ext) => {
    // We explicitly only use `stories` since any `story` has
    // not yet been migrated from v2 to v3.
    return `../${ext.theme}/**/*.stories.@(js|jsx|mjs|ts|tsx)`;
  });

/**
 * This function is used to resolve the absolute path of a package.
 * It is needed in projects that use Yarn PnP or are set up within a monorepo.
 */
function getAbsolutePath(value: string): any {
  return dirname(require.resolve(join(value, "package.json")));
}

export default {
  stories: ["../**/*.stories.@(js|jsx|mjs|ts|tsx)", ...extensionThemeStories],

  addons: [
    getAbsolutePath("@storybook/addon-onboarding"),
    getAbsolutePath("@storybook/addon-links"),
    getAbsolutePath("@chromatic-com/storybook"),
    getAbsolutePath("storybook-react-intl"),
    getAbsolutePath("@storybook/addon-docs"),
  ],

  framework: {
    name: getAbsolutePath("@storybook/react-vite"),
    options: {
      builder: {
        viteConfigPath: "vite-storybook.config.ts",
      },
    },
  },

  staticDirs: ["../public"],
} satisfies StorybookConfig;
