import { reactIntl } from "./reactIntl";
import type { Preview } from "@storybook/react-vite";
import "theme/main.scss";
import { publicConfig } from "./publicConfig";
import { createFrontCommerceProviderStub } from "@front-commerce/core/testing/react";

const preview: Preview = {
  initialGlobals: {
    locale: reactIntl.defaultLocale,
    locales: {
      en: "English",
      fr: "Français",
    },
  },
  parameters: {
    reactIntl,
    publicConfig,
    controls: {
      matchers: {
        color: /(background|color)$/i,
        date: /Date$/i,
      },
    },
  },
  decorators: [
    (StoryFn, { parameters, globals }) => {
      const FrontCommerceProviderStub = createFrontCommerceProviderStub();

      parameters.publicConfig.shop.locale = globals.locale;

      return (
        <FrontCommerceProviderStub
          messages={reactIntl.messages[globals.locale]}
          publicConfig={parameters.publicConfig}
        >
          {StoryFn()}
        </FrontCommerceProviderStub>
      );
    },
  ],
  tags: ["autodocs"],
};

export default preview;
