# front-commerce-skeleton

## 3.17.0

### Minor Changes

- 528287b47da06f8d7e777f097ab30b17ff76b082: Upgrade Storybook version from 8.6.16 to 10.1.0 (bugsfc #67980)
- aa0da8f3c99948c507e11f74b38920abee15fbaa: Update minimum Node.js version to 20.19.0 (bugsfc #68412)

## 3.16.0

## 3.15.0

### Minor Changes

- 87701bbcdff44a5ba4c584632be28d3d1f1f3920: Add `restrictQuantitiesByPackaging` in stores config to enforce packaging selection on the product page (FC-3103)

## 3.14.0

### Minor Changes

- 9495eeb9c62fa8c04d283ed4958868b2d80f4485: Added new debug scripts in package.json.

### Patch Changes

- 9844c88459620d76d34a12cdcf56a81562e6a654: Fixes the service worker initialization by replacing dynamic import of `setupPwa` with a static import.

## 3.13.0

### Minor Changes

- df7b1f71df77bbe486bfd0d1d278585652a42b30: Implement example of custom redirections

## 3.12.0

### Patch Changes

- 04b29c9bc41914cb9dd989f63c8f28da26debaff: Fix an issue where Service Worker fails to load on Firefox in localhost

To apply this fix for versions prior to 3.12.x, you should run the following codemod:

\`\`\`bash
pnpm run migrate --transforms=sw-async
\`\`\`

## 3.11.0

## 3.11.0-beta.1

## 3.11.0-beta.0

## 3.10.0

### Minor Changes

- af7d4e8b753f34cd794cc97066fa5d8f6ca8269b: Implement `remix-development-tools` in skeleton

### Patch Changes

- ad31d7a9b00eb0fefd28cc82b0b3462a2b6eb941: Fixes a race condition issue in data revalidation. The issue occurred when components were unmounted during layout changes, triggering unnecessary revalidation requests. This could lead to stale data or inconsistent UI states. The fix prevents these superfluous revalidations during layout transitions.

> ⚠️ If you're updating from a version prior to 3.10.x, you need to run the following codemod:
>
> ```bash
> pnpm run front-commerce migrate --transform move-magic-button-to-root
> ```

## 3.9.0

### Minor Changes

- 8f79e518d394b9b74398bd96e30ae05cee81c991: Include Vscode configuration to launch Front-Commerce in debug mode
- 0a9c1d53d22a9cd11d8e4fc9eac016781dfcfa0f: Introduced new `generateAppRouteErrorMeta` to handle route error customizations for seo meta tags.

> If you overrode any of the following components, please ensure you update them to use their respective `messages` imports:
>
> - [`theme/pages/Error/Maintenance/Maintenance.tsx`](https://gitlab.blackswift.cloud/front-commerce/front-commerce/-/blob/fc-3020-error-route-seo-meta/packages/theme-chocolatine/theme/pages/Error/Maintenance/Maintenance.tsx#L4)
>
>   ```tsx
>   import { maintenancePageMessages } from "theme/pages/Error/Maintenance/messages";
>   ```
>
> - [`theme/pages/Error/RateLimit/RateLimit.tsx`](https://gitlab.blackswift.cloud/front-commerce/front-commerce/-/blob/fc-3020-error-route-seo-meta/packages/theme-chocolatine/theme/pages/Error/RateLimit/RateLimit.tsx#L5)
>
>   ```tsx
>   import { rateLimitPageMessages } from "theme/pages/Error/RateLimit/messages";
>   ```
>
> - [`theme/modules/PageError/NotFound/NotFound.jsx`](https://gitlab.blackswift.cloud/front-commerce/front-commerce/-/blob/fc-3020-error-route-seo-meta/packages/theme-chocolatine/theme/modules/PageError/NotFound/NotFound.jsx#L5)
>
>   ```tsx
>   import { notFoundPageMessages } from "theme/modules/PageError/NotFound/messages";
>   ```

- e2827520486c8566667c13a541fd6df4ac021157: Integrated theme stories from extensions into Storybook configuration

> - Converted `Money`, `Price`, `PriceOrFree`, and `ProductPrice` components to TypeScript
> - Removed `propTypes` from these components for improved type safety
> - **FUTURE BREAKING CHANGE**: PropTypes for these components will be removed in the next major version
> - If you were using PropTypes for these components, please update your code to use TypeScript types instead

- 9427d19a272ea5124ee5b590e2fc5630899013fe: Implement `root-error-meta` extension feature for Remix route errors.
- a57e7c7986bf44b407a021aef3393ba2ac8fde10: Adds consent options to Cookie services for more granular consent control
- 299a8f4b74c10d3f8e7e63c1a0a71dd77a5adeaf: Implement storybook stories for components which will be using the new `PriceVariant` component.

### Patch Changes

- 107e948e5f7772f2701d0ebf47324ca2c74adcc1: Use configuration instead of store configuration file into V2 Compat server. You need to run the 3.8.1 codemod to update your code by running `pnpm run front-commerce migrate --transform 3.8.1`
- c7868bed215b4224c00a610d29f88b6e691ba073: Fix an issue where environement wasn't detected properly for images
- a5f61315d5157352d0bf16fdac821db901774948: Fixed an issue in Magento2 demo example extension causing the Magic Button not to be correctly displayed because of page cache

## 3.8.0

### Minor Changes

- 5f23e92: Implement ErrorBoundary components to handle different route errors.

  > Introduced `GenericError`, `RootErrorBoundary`, and `LayoutErrorBoundary` components for handling different types of errors.
  > Added `createErrorOverlay` function to dynamically create and manage error overlays.

- dd14369: Fix an issue where PWA manifest can't be accessed when the app is behind a Basic Auth

### Patch Changes

- 4bc7af0: Enforce `@opentelemetry/instrumentation` in skeleton via peer dependency of '@front-commerce/remix`

  > This ensures that the telemetry works in production build builds.

- Updated dependencies [42317f7]
- Updated dependencies [14a84e1]
- Updated dependencies [5f23e92]
- Updated dependencies [4352551]
- Updated dependencies [8747e58]
- Updated dependencies [3cbdf53]
- Updated dependencies [0bbc3b3]
- Updated dependencies [326a6f2]
- Updated dependencies [45629d4]
- Updated dependencies [b1823e9]
- Updated dependencies [04245b3]
- Updated dependencies [0de5f8b]
- Updated dependencies [f26803a]
- Updated dependencies [f74203e]
- Updated dependencies [b7a8aa9]
- Updated dependencies [f03e674]
- Updated dependencies [4bc7af0]
- Updated dependencies [8c27d2e]
- Updated dependencies [954996d]
- Updated dependencies [2ea88a4]
- Updated dependencies [60d3012]
- Updated dependencies [d92bcc3]
- Updated dependencies [f50ad61]
- Updated dependencies [b4c3c90]
- Updated dependencies [611d5a2]
- Updated dependencies [96fc74d]
- Updated dependencies [291c291]
- Updated dependencies [2397e30]
- Updated dependencies [70b37d1]
- Updated dependencies [5c31e94]
- Updated dependencies [216da12]
- Updated dependencies [4006d91]
- Updated dependencies [8980db9]
- Updated dependencies [0d092c9]
- Updated dependencies [34f9553]
- Updated dependencies [7fe138b]
- Updated dependencies [85aefba]
- Updated dependencies [bb07e11]
- Updated dependencies [ea0d71f]
- Updated dependencies [af7501c]
- Updated dependencies [0e0435c]
- Updated dependencies [04fe34e]
- Updated dependencies [a1274a5]
- Updated dependencies [695b0e7]
- Updated dependencies [3da06bc]
- Updated dependencies [2818e94]
  - @front-commerce/core@3.8.0
  - @front-commerce/theme-chocolatine@3.8.0
  - @front-commerce/remix@3.8.0
  - @front-commerce/twicpics@3.8.0
  - @front-commerce/gezy@3.8.0
  - @front-commerce/magento1@3.8.0
  - @front-commerce/magento2@3.8.0
  - @front-commerce/paypal@3.8.0
  - @front-commerce/payzen@3.8.0
  - @front-commerce/stripe@3.8.0
  - @front-commerce/adobe-b2b@3.8.0
  - @front-commerce/adyen@3.8.0
  - @front-commerce/compat@3.8.0
  - @front-commerce/contentful@3.8.0
  - @front-commerce/external-login-providers@3.8.0

## 3.7.0

### Patch Changes

- 35ba787: Fixed an issue causing the server to crash in a development environment due to Vite optimisation.

  > [vite] Error when evaluating SSR module virtual:front-commerce/config: failed to import "contentful"
  > |- SyntaxError: [vite] Named export 'default' not found. The requested module 'contentful' is a CommonJS module, which may not support all module.exports as named exports.
  > CommonJS modules can always be imported via the default export, for example using:
  >
  > import pkg from 'contentful';
  > const {default} = pkg;

- f4f50e7: A version of `rollup` (dependency of vite) has been pinned because of a issue with the latest version (4.19.1) which would cause the skeleton not to build properly.

  Error :

  > [vite-plugin-pwa:build] Cannot read properties of null (reading 'getLiteralValueAtPath')

- Updated dependencies [eab3716]
- Updated dependencies [b17212d]
- Updated dependencies [327cc86]
- Updated dependencies [fc8d363]
- Updated dependencies [b314716]
- Updated dependencies [7cb61be]
- Updated dependencies [a2ee5c4]
- Updated dependencies [49bda0e]
- Updated dependencies [30f8333]
- Updated dependencies [49bb36d]
- Updated dependencies [ddd971a]
- Updated dependencies [73819fd]
- Updated dependencies [cf42a98]
- Updated dependencies [4b0ee2e]
- Updated dependencies [35ba787]
- Updated dependencies [1c403b8]
- Updated dependencies [b081621]
- Updated dependencies [817964e]
- Updated dependencies [e90740c]
- Updated dependencies [f6cefe8]
- Updated dependencies [4254c13]
- Updated dependencies [bc700dd]
  - @front-commerce/remix@3.7.0
  - @front-commerce/gezy@3.7.0
  - @front-commerce/theme-chocolatine@3.7.0
  - @front-commerce/magento2@3.7.0
  - @front-commerce/adyen@3.7.0
  - @front-commerce/magento1@3.7.0
  - @front-commerce/contentful@3.7.0
  - @front-commerce/core@3.7.0
  - @front-commerce/adobe-b2b@3.7.0
  - @front-commerce/external-login-providers@3.7.0
  - @front-commerce/paypal@3.7.0
  - @front-commerce/payzen@3.7.0
  - @front-commerce/stripe@3.7.0
  - @front-commerce/compat@3.7.0
  - @front-commerce/twicpics@3.7.0

## 3.6.0

### Minor Changes

- c33ffe5: Added server timings header calculation for remix loaders, SSR and Graphql queries and mutations.

### Patch Changes

- 162dc5e: Pin `react` and `react-dom` to canary version to avoid hydration issues during hmr

  > see https://github.com/remix-run/remix/issues/4822#issuecomment-2130006831

- f080bcb: Load `<FrontCommerceScripts />` in the `<head>` to make public configurations available for all modules
- Updated dependencies [6025228]
- Updated dependencies [f6fd7ff]
- Updated dependencies [f5e798f]
- Updated dependencies [cb6fcae]
- Updated dependencies [c33ffe5]
- Updated dependencies [d24d472]
- Updated dependencies [479e91c]
- Updated dependencies [162dc5e]
- Updated dependencies [367b486]
- Updated dependencies [3b3ef85]
- Updated dependencies [1327d49]
- Updated dependencies [d714452]
- Updated dependencies [3b349a6]
- Updated dependencies [5dfbba6]
- Updated dependencies [f300d73]
- Updated dependencies [0ce8c9c]
- Updated dependencies [316e621]
- Updated dependencies [e144e10]
- Updated dependencies [ed445a9]
- Updated dependencies [ea709de]
- Updated dependencies [18d00fd]
- Updated dependencies [5b4fdc0]
- Updated dependencies [008e2d8]
- Updated dependencies [8fde595]
- Updated dependencies [f32e962]
- Updated dependencies [21b8567]
- Updated dependencies [7488188]
- Updated dependencies [ed9a55d]
- Updated dependencies [86beb25]
- Updated dependencies [d31e801]
- Updated dependencies [31d5681]
- Updated dependencies [9fe5cb9]
- Updated dependencies [e140fd2]
- Updated dependencies [8cbbe5f]
- Updated dependencies [1aae494]
- Updated dependencies [7d70f28]
- Updated dependencies [3904f67]
- Updated dependencies [4c52717]
- Updated dependencies [d3bc6a5]
- Updated dependencies [ba30c45]
- Updated dependencies [cca7100]
- Updated dependencies [2883b24]
- Updated dependencies [6469f2a]
- Updated dependencies [fdd5309]
- Updated dependencies [3eb25cd]
- Updated dependencies [5028d24]
- Updated dependencies [ab32e8d]
- Updated dependencies [929ab70]
- Updated dependencies [870a238]
- Updated dependencies [3efd836]
- Updated dependencies [39a9e05]
  - @front-commerce/paypal@3.6.0
  - @front-commerce/remix@3.6.0
  - @front-commerce/theme-chocolatine@3.6.0
  - @front-commerce/core@3.6.0
  - @front-commerce/adobe-b2b@3.6.0
  - @front-commerce/magento1@3.6.0
  - @front-commerce/magento2@3.6.0
  - @front-commerce/external-login-providers@3.6.0
  - @front-commerce/contentful@3.6.0
  - @front-commerce/twicpics@3.6.0
  - @front-commerce/compat@3.6.0
  - @front-commerce/payzen@3.6.0
  - @front-commerce/stripe@3.6.0
  - @front-commerce/gezy@3.6.0

## 3.6.0-beta.0

### Patch Changes

- Updated dependencies [cb6fcae]
- Updated dependencies [d24d472]
- Updated dependencies [367b486]
- Updated dependencies [d714452]
- Updated dependencies [3b349a6]
- Updated dependencies [f300d73]
- Updated dependencies [e144e10]
- Updated dependencies [ea709de]
- Updated dependencies [5b4fdc0]
- Updated dependencies [008e2d8]
- Updated dependencies [21b8567]
- Updated dependencies [d31e801]
- Updated dependencies [8cbbe5f]
- Updated dependencies [d3bc6a5]
- Updated dependencies [ba30c45]
- Updated dependencies [cca7100]
- Updated dependencies [2883b24]
- Updated dependencies [6469f2a]
- Updated dependencies [3eb25cd]
- Updated dependencies [5028d24]
- Updated dependencies [929ab70]
- Updated dependencies [870a238]
- Updated dependencies [3efd836]
  - @front-commerce/theme-chocolatine@3.6.0-beta.0
  - @front-commerce/core@3.6.0-beta.0
  - @front-commerce/remix@3.6.0-beta.0
  - @front-commerce/magento2@3.6.0-beta.0
  - @front-commerce/magento1@3.6.0-beta.0
  - @front-commerce/adobe-b2b@3.6.0-beta.0
  - @front-commerce/compat@3.6.0-beta.0
  - @front-commerce/contentful@3.6.0-beta.0
  - @front-commerce/external-login-providers@3.6.0-beta.0
  - @front-commerce/paypal@3.6.0-beta.0
  - @front-commerce/payzen@3.6.0-beta.0
  - @front-commerce/stripe@3.6.0-beta.0
  - @front-commerce/twicpics@3.6.0-beta.0

## 3.5.0

### Minor Changes

- 12f6a8d: Implement hydration for dynamic routes
- c760f7f: Implement CSR dynamic route module resolution

### Patch Changes

- Updated dependencies [82ea03b]
- Updated dependencies [12f6a8d]
- Updated dependencies [0a96c73]
- Updated dependencies [a8039e5]
- Updated dependencies [928836a]
- Updated dependencies [031bd2a]
- Updated dependencies [b11998d]
- Updated dependencies [c760f7f]
- Updated dependencies [9a3621b]
- Updated dependencies [5723bc4]
- Updated dependencies [890fb65]
- Updated dependencies [2319550]
- Updated dependencies [d38a5a5]
- Updated dependencies [1bfd5ba]
- Updated dependencies [60f9daa]
- Updated dependencies [a629bce]
- Updated dependencies [8c0140f]
- Updated dependencies [72c76db]
- Updated dependencies [b7911ab]
- Updated dependencies [d5d2342]
- Updated dependencies [a1de0e1]
- Updated dependencies [c3731f0]
- Updated dependencies [391585c]
- Updated dependencies [cb54acf]
- Updated dependencies [66db694]
- Updated dependencies [23de2d8]
- Updated dependencies [4251b45]
- Updated dependencies [3d98038]
- Updated dependencies [b9e175b]
- Updated dependencies [5a5571b]
- Updated dependencies [81797d0]
- Updated dependencies [e258c9e]
- Updated dependencies [3691f2a]
- Updated dependencies [d1a4ef9]
- Updated dependencies [5cb9883]
- Updated dependencies [c718772]
- Updated dependencies [ddda7b6]
- Updated dependencies [3f62df8]
- Updated dependencies [5915331]
- Updated dependencies [50c96fa]
- Updated dependencies [beb44de]
- Updated dependencies [1973868]
- Updated dependencies [2c76f79]
- Updated dependencies [86c77d6]
- Updated dependencies [3a12f03]
- Updated dependencies [7c8878a]
- Updated dependencies [e734c9b]
- Updated dependencies [b399794]
  - @front-commerce/theme-chocolatine@3.5.0
  - @front-commerce/remix@3.5.0
  - @front-commerce/core@3.5.0
  - @front-commerce/magento2@3.5.0
  - @front-commerce/magento1@3.5.0
  - @front-commerce/compat@3.5.0
  - @front-commerce/twicpics@3.5.0
  - @front-commerce/adobe-b2b@3.5.0
  - @front-commerce/contentful@3.5.0
  - @front-commerce/external-login-providers@3.5.0
  - @front-commerce/paypal@3.5.0
  - @front-commerce/payzen@3.5.0
  - @front-commerce/stripe@3.5.0

## 3.5.0-beta.1

### Patch Changes

- Updated dependencies [391585c]
- Updated dependencies [4251b45]
  - @front-commerce/core@3.5.0-beta.1
  - @front-commerce/adobe-b2b@3.5.0-beta.1
  - @front-commerce/compat@3.5.0-beta.1
  - @front-commerce/contentful@3.5.0-beta.1
  - @front-commerce/external-login-providers@3.5.0-beta.1
  - @front-commerce/magento1@3.5.0-beta.1
  - @front-commerce/magento2@3.5.0-beta.1
  - @front-commerce/paypal@3.5.0-beta.1
  - @front-commerce/payzen@3.5.0-beta.1
  - @front-commerce/remix@3.5.0-beta.1
  - @front-commerce/stripe@3.5.0-beta.1
  - @front-commerce/theme-chocolatine@3.5.0-beta.1

## 3.5.0-beta.0

### Minor Changes

- Dynamic Routing Feature
  - e4f0f32: Implement hydration for dynamic routes
  - 5da366e: Implement CSR dynamic route module resolution

### Patch Changes

- Updated dependencies [82ea03b]
- Updated dependencies [e4f0f32]
- Updated dependencies [0a96c73]
- Updated dependencies [c944292]
- Updated dependencies [928836a]
- Updated dependencies [b11998d]
- Updated dependencies [5da366e]
- Updated dependencies [5723bc4]
- Updated dependencies [890fb65]
- Updated dependencies [2319550]
- Updated dependencies [9ff3141]
- Updated dependencies [510f365]
- Updated dependencies [d5d2342]
- Updated dependencies [a1de0e1]
- Updated dependencies [c3731f0]
- Updated dependencies [66db694]
- Updated dependencies [1f5aa77]
- Updated dependencies [663b0ed]
- Updated dependencies [b9e175b]
- Updated dependencies [6d23f52]
- Updated dependencies [d1a4ef9]
- Updated dependencies [5cb9883]
- Updated dependencies [c718772]
- Updated dependencies [ddda7b6]
- Updated dependencies [5915331]
- Updated dependencies [50c96fa]
- Updated dependencies [1973868]
- Updated dependencies [026a865]
- Updated dependencies [7c8878a]
- Updated dependencies [e734c9b]
  - @front-commerce/theme-chocolatine@3.5.0-beta.0
  - @front-commerce/remix@3.5.0-beta.0
  - @front-commerce/core@3.5.0-beta.0
  - @front-commerce/magento2@3.5.0-beta.0
  - @front-commerce/magento1@3.5.0-beta.0
  - @front-commerce/compat@3.5.0-beta.0
  - @front-commerce/adobe-b2b@3.5.0-beta.0
  - @front-commerce/contentful@3.5.0-beta.0
  - @front-commerce/external-login-providers@3.5.0-beta.0
  - @front-commerce/paypal@3.5.0-beta.0
  - @front-commerce/payzen@3.5.0-beta.0
  - @front-commerce/stripe@3.5.0-beta.0

## 3.4.0

### Minor Changes

- 2a63fb4: Include `.gitignore` in skeleton template
- 3f44acf: Adds the pwa assets and manifest generator in the `front-commerce-pwa` vite plugin
- 77e02ee: Added storybook to skeleton alongside some simple example stories.
- bc6d251: Add `vitest` plugin and skeleton setup to allow testing based on extension config
- 568f2ab: This implements the express server instance in the remix package
- b9840a7: Remove Magento2 from the default `front-commerce.config.ts` so that it's unopinionated
- 532915f: Added theme components for CmsBlock support
- 6dfdfc2: Add memoized translated messages loader with vite hot reload for translation changes
- 62749a9: Implement storefront-content in service worker
- 800106b: Move `entry.worker.ts` logic to remix package and add `WB_MANIFEST` precache
- 20fe1ac: Implement `vite-pwa` and `@vite-pwa/assets-generator` for service worker and manifest generation.
- aa50d80: Implements a `tsconfig.json` generator in the vite plugins
- 0cb2bf0: Handle Offline page through the service worker.
- bed0a5b: Added Maintenance mode demo example extension to showcase the maintenance mode behavior in typical route use cases.
- eb44a81: Add PWA offline fallback options to `PWA` config and `FrontCommerceAppManifest` and re-use in sw installation
- dbfc24e: This implements the resolve::alias vite config. Additionaly it adds the noExternal in the front-commerce:remix plugin and moves the vite-tsconfig-paths to the frontCommerce plugin list
- dbad684: Mark `sharp` as a peerDep for `core` package and install in `skeleton`

### Patch Changes

- d4e2685: Updated `shop` usage in `root.tsx` to `publicConfig` instead.
- Updated dependencies [6a4bd0e]
- Updated dependencies [360d341]
- Updated dependencies [25dfaac]
- Updated dependencies [fa74fa5]
- Updated dependencies [989221e]
- Updated dependencies [b9df68e]
- Updated dependencies [5d6c2ab]
- Updated dependencies [cbe8327]
- Updated dependencies [fb44e8f]
- Updated dependencies [9ea3e07]
- Updated dependencies [c31fc43]
- Updated dependencies [c9d9c62]
- Updated dependencies [00ce12c]
- Updated dependencies [3f44acf]
- Updated dependencies [2047575]
- Updated dependencies [e270715]
- Updated dependencies [f7f9273]
- Updated dependencies [ba2f970]
- Updated dependencies [c58526c]
- Updated dependencies [af61e03]
- Updated dependencies [77e02ee]
- Updated dependencies [0e48f39]
- Updated dependencies [d550f4c]
- Updated dependencies [ba2f970]
- Updated dependencies [8bc8384]
- Updated dependencies [ba2f970]
- Updated dependencies [f1fe7e0]
- Updated dependencies [3340f0f]
- Updated dependencies [de54dee]
- Updated dependencies [183213f]
- Updated dependencies [ef68cf6]
- Updated dependencies [d554f7b]
- Updated dependencies [d1c04c1]
- Updated dependencies [89565c5]
- Updated dependencies [f72d0b3]
- Updated dependencies [e39b288]
- Updated dependencies [754bdd2]
- Updated dependencies [ca72101]
- Updated dependencies [942b1ca]
- Updated dependencies [9711ad1]
- Updated dependencies [bc6d251]
- Updated dependencies [b0bcc11]
- Updated dependencies [c6aa644]
- Updated dependencies [568f2ab]
- Updated dependencies [cb9aa30]
- Updated dependencies [fca7412]
- Updated dependencies [d7404ff]
- Updated dependencies [ca08783]
- Updated dependencies [681d686]
- Updated dependencies [e1fb570]
- Updated dependencies [5c1bdc8]
- Updated dependencies [062080f]
- Updated dependencies [de62885]
- Updated dependencies [2857b6f]
- Updated dependencies [37ca664]
- Updated dependencies [2adace5]
- Updated dependencies [5d65488]
- Updated dependencies [532915f]
- Updated dependencies [13ec378]
- Updated dependencies [3db4fd7]
- Updated dependencies [2886bd9]
- Updated dependencies [f20a3c8]
- Updated dependencies [e567f0a]
- Updated dependencies [6dfdfc2]
- Updated dependencies [6a7772c]
- Updated dependencies [cd4b61f]
- Updated dependencies [0fb7e20]
- Updated dependencies [62749a9]
- Updated dependencies [02fd6bd]
- Updated dependencies [40860fb]
- Updated dependencies [800106b]
- Updated dependencies [b489241]
- Updated dependencies [66bc79c]
- Updated dependencies [2988733]
- Updated dependencies [58b1234]
- Updated dependencies [bf830b5]
- Updated dependencies [c34fa7e]
- Updated dependencies [bc572e0]
- Updated dependencies [b46dfa6]
- Updated dependencies [700fcf7]
- Updated dependencies [dc4b31d]
- Updated dependencies [20fe1ac]
- Updated dependencies [0d04ff4]
- Updated dependencies [a292699]
- Updated dependencies [b044e5d]
- Updated dependencies [7f50d58]
- Updated dependencies [0170cbf]
- Updated dependencies [9be06aa]
- Updated dependencies [b298c26]
- Updated dependencies [8f7d3d7]
- Updated dependencies [d7f6957]
- Updated dependencies [73a05b8]
- Updated dependencies [21b2b3f]
- Updated dependencies [a19b7cc]
- Updated dependencies [2ea8049]
- Updated dependencies [6c1f58a]
- Updated dependencies [ed8f406]
- Updated dependencies [60226b3]
- Updated dependencies [1068b02]
- Updated dependencies [8c91beb]
- Updated dependencies [de15349]
- Updated dependencies [da1c4c4]
- Updated dependencies [0a19be1]
- Updated dependencies [aa50d80]
- Updated dependencies [7b7aaeb]
- Updated dependencies [bbcb70a]
- Updated dependencies [702f430]
- Updated dependencies [4fbff17]
- Updated dependencies [0242fc8]
- Updated dependencies [eb44a81]
- Updated dependencies [7c84b50]
- Updated dependencies [e6b7649]
- Updated dependencies [dbfc24e]
- Updated dependencies [2c86080]
- Updated dependencies [008d7f6]
- Updated dependencies [415b44b]
- Updated dependencies [d8ba67c]
- Updated dependencies [67d9375]
- Updated dependencies [98e4844]
- Updated dependencies [e9eff16]
- Updated dependencies [c7628d9]
- Updated dependencies [919ee08]
- Updated dependencies [84a0fa9]
- Updated dependencies [83fe198]
- Updated dependencies [d5e98a6]
- Updated dependencies [7eb4350]
- Updated dependencies [92d3ba4]
- Updated dependencies [b1ab627]
- Updated dependencies [ccb874d]
- Updated dependencies [772cc4a]
- Updated dependencies [4aa8e5b]
- Updated dependencies [dbad684]
- Updated dependencies [a68df00]
- Updated dependencies [bbcb70a]
  - @front-commerce/remix@3.5.0
  - @front-commerce/theme-chocolatine@3.5.0
  - @front-commerce/magento2@3.5.0
  - @front-commerce/magento1@3.5.0
  - @front-commerce/adobe-b2b@3.5.0
  - @front-commerce/paypal@3.5.0
  - @front-commerce/core@3.5.0
  - @front-commerce/compat@3.5.0
  - @front-commerce/contentful@3.5.0
  - @front-commerce/payzen@3.5.0
  - @front-commerce/external-login-providers@3.5.0
  - @front-commerce/stripe@3.5.0

## 3.4.0-beta.3

### Minor Changes

- 0cb2bf0: Handle Offline page through the service worker.

### Patch Changes

- Updated dependencies [360d341]
- Updated dependencies [5d6c2ab]
- Updated dependencies [9ea3e07]
- Updated dependencies [c58526c]
- Updated dependencies [d7404ff]
- Updated dependencies [2adace5]
- Updated dependencies [c34fa7e]
- Updated dependencies [bc572e0]
- Updated dependencies [da1c4c4]
- Updated dependencies [bbcb70a]
- Updated dependencies [0242fc8]
- Updated dependencies [2c86080]
- Updated dependencies [d8ba67c]
- Updated dependencies [772cc4a]
- Updated dependencies [bbcb70a]
  - @front-commerce/theme-chocolatine@3.4.0-beta.3
  - @front-commerce/remix@3.4.0-beta.3
  - @front-commerce/paypal@3.4.0-beta.3
  - @front-commerce/magento2@3.4.0-beta.3
  - @front-commerce/core@3.4.0-beta.3
  - @front-commerce/external-login-providers@3.4.0-beta.3
  - @front-commerce/adobe-b2b@3.4.0-beta.3
  - @front-commerce/contentful@3.4.0-beta.3
  - @front-commerce/magento1@3.4.0-beta.3
  - @front-commerce/payzen@3.4.0-beta.3
  - @front-commerce/stripe@3.4.0-beta.3
  - @front-commerce/compat@3.4.0-beta.3

## 3.4.0-beta.2

### Minor Changes

- 3f44acf: Adds the pwa assets and manifest generator in the `front-commerce-pwa` vite plugin
- bc6d251: Add `vitest` plugin and skeleton setup to allow testing based on extension config
- 568f2ab: This implements the express server instance in the remix package
- b9840a7: Remove Magento2 from the default `front-commerce.config.ts` so that it's unopinionated
- 6dfdfc2: Add memoized translated messages loader with vite hot reload for translation changes
- 62749a9: Implement storefront-content in service worker
- 20fe1ac: Implement `vite-pwa` and `@vite-pwa/assets-generator` for service worker and manifest generation.
- aa50d80: Implements a `tsconfig.json` generator in the vite plugins
- dbfc24e: This implements the resolve::alias vite config. Additionaly it adds the noExternal in the front-commerce:remix plugin and moves the vite-tsconfig-paths to the frontCommerce plugin list
- dbad684: Mark `sharp` as a peerDep for `core` package and install in `skeleton`

### Patch Changes

- d4e2685: Updated `shop` usage in `root.tsx` to `publicConfig` instead.
- Updated dependencies [25dfaac]
- Updated dependencies [fa74fa5]
- Updated dependencies [989221e]
- Updated dependencies [fb44e8f]
- Updated dependencies [c31fc43]
- Updated dependencies [00ce12c]
- Updated dependencies [3f44acf]
- Updated dependencies [2047575]
- Updated dependencies [e270715]
- Updated dependencies [f7f9273]
- Updated dependencies [ba2f970]
- Updated dependencies [d550f4c]
- Updated dependencies [ba2f970]
- Updated dependencies [8bc8384]
- Updated dependencies [ba2f970]
- Updated dependencies [f1fe7e0]
- Updated dependencies [de54dee]
- Updated dependencies [183213f]
- Updated dependencies [d1c04c1]
- Updated dependencies [89565c5]
- Updated dependencies [f72d0b3]
- Updated dependencies [e39b288]
- Updated dependencies [ca72101]
- Updated dependencies [bc6d251]
- Updated dependencies [c6aa644]
- Updated dependencies [568f2ab]
- Updated dependencies [cb9aa30]
- Updated dependencies [fca7412]
- Updated dependencies [ca08783]
- Updated dependencies [681d686]
- Updated dependencies [062080f]
- Updated dependencies [2857b6f]
- Updated dependencies [37ca664]
- Updated dependencies [5d65488]
- Updated dependencies [13ec378]
- Updated dependencies [3db4fd7]
- Updated dependencies [f20a3c8]
- Updated dependencies [e567f0a]
- Updated dependencies [6dfdfc2]
- Updated dependencies [0fb7e20]
- Updated dependencies [62749a9]
- Updated dependencies [b489241]
- Updated dependencies [66bc79c]
- Updated dependencies [2988733]
- Updated dependencies [58b1234]
- Updated dependencies [b46dfa6]
- Updated dependencies [700fcf7]
- Updated dependencies [20fe1ac]
- Updated dependencies [0d04ff4]
- Updated dependencies [b044e5d]
- Updated dependencies [7f50d58]
- Updated dependencies [0170cbf]
- Updated dependencies [8f7d3d7]
- Updated dependencies [d7f6957]
- Updated dependencies [73a05b8]
- Updated dependencies [21b2b3f]
- Updated dependencies [2ea8049]
- Updated dependencies [6c1f58a]
- Updated dependencies [ed8f406]
- Updated dependencies [60226b3]
- Updated dependencies [1068b02]
- Updated dependencies [8c91beb]
- Updated dependencies [de15349]
- Updated dependencies [aa50d80]
- Updated dependencies [7b7aaeb]
- Updated dependencies [702f430]
- Updated dependencies [4fbff17]
- Updated dependencies [7c84b50]
- Updated dependencies [dbfc24e]
- Updated dependencies [008d7f6]
- Updated dependencies [e9eff16]
- Updated dependencies [c7628d9]
- Updated dependencies [d5e98a6]
- Updated dependencies [92d3ba4]
- Updated dependencies [ccb874d]
- Updated dependencies [dbad684]
  - @front-commerce/magento2@3.4.0-beta.2
  - @front-commerce/remix@3.4.0-beta.2
  - @front-commerce/magento1@3.4.0-beta.2
  - @front-commerce/core@3.4.0-beta.2
  - @front-commerce/compat@3.4.0-beta.2
  - @front-commerce/adobe-b2b@3.4.0-beta.2
  - @front-commerce/theme-chocolatine@3.4.0-beta.2
  - @front-commerce/contentful@3.4.0-beta.2
  - @front-commerce/payzen@3.4.0-beta.2
  - @front-commerce/paypal@3.4.0-beta.2
  - @front-commerce/stripe@3.4.0-beta.2

## 3.4.0-beta.1

### Minor Changes

- 2a63fb4: Include `.gitignore` in skeleton template

### Patch Changes

- Updated dependencies [b9df68e]
- Updated dependencies [cbe8327]
- Updated dependencies [ef68cf6]
- Updated dependencies [6a7772c]
- Updated dependencies [67d9375]
- Updated dependencies [b1ab627]
- Updated dependencies [4aa8e5b]
  - @front-commerce/adobe-b2b@3.4.0-beta.1
  - @front-commerce/remix@3.4.0-beta.1
  - @front-commerce/magento2@3.4.0-beta.1
  - @front-commerce/theme-chocolatine@3.4.0-beta.1
  - @front-commerce/contentful@3.4.0-beta.1
  - @front-commerce/magento1@3.4.0-beta.1
  - @front-commerce/payzen@3.4.0-beta.1
  - @front-commerce/compat@3.4.0-beta.1
  - @front-commerce/core@3.4.0-beta.1

## 3.4.0-beta.0

### Patch Changes

- Updated dependencies [0e48f39]
- Updated dependencies [754bdd2]
- Updated dependencies [942b1ca]
- Updated dependencies [9711ad1]
- Updated dependencies [cd4b61f]
- Updated dependencies [9be06aa]
- Updated dependencies [0a19be1]
- Updated dependencies [e6b7649]
- Updated dependencies [84a0fa9]
- Updated dependencies [7eb4350]
  - @front-commerce/remix@3.4.0-beta.0
  - @front-commerce/payzen@3.4.0-beta.0
  - @front-commerce/core@3.4.0-beta.0
  - @front-commerce/theme-chocolatine@3.4.0-beta.0
  - @front-commerce/magento2@3.4.0-beta.0
  - @front-commerce/adobe-b2b@3.4.0-beta.0
  - @front-commerce/contentful@3.4.0-beta.0
  - @front-commerce/magento1@3.4.0-beta.0
  - @front-commerce/compat@3.4.0-beta.0

## 3.3.0

### Minor Changes

- 763db98: Reworked how FC extends Remix in `server.ts`

  It replaces the `FrontCommerceMiddleware` with a `createRequestHandler` factory (drop-in Remix's replacement), responsible for everything FC specific for handling requests.
  That also removes the need to initialize Remix's loadContext in `server.ts`.

### Patch Changes

- b6381e9: Moved skeleton/extensions to skeleton/example-extensions
- 6b48b68: Added missing translations to magento1 demo extension
- Updated dependencies [49822b9]
- Updated dependencies [0ff4246]
- Updated dependencies [3ea550b]
- Updated dependencies [fafaf79]
- Updated dependencies [9244431]
- Updated dependencies [11b7ed6]
- Updated dependencies [64471ea]
- Updated dependencies [7f8dbf6]
- Updated dependencies [772ee8e]
- Updated dependencies [4dcd85b]
- Updated dependencies [763db98]
- Updated dependencies [a0c757c]
- Updated dependencies [0f13045]
- Updated dependencies [ea21686]
- Updated dependencies [242fc83]
- Updated dependencies [65288ed]
- Updated dependencies [fdaa314]
- Updated dependencies [5094291]
- Updated dependencies [8956474]
- Updated dependencies [a6a14a9]
- Updated dependencies [1e5d1f8]
- Updated dependencies [3b96f29]
- Updated dependencies [f70ee5e]
- Updated dependencies [71fb405]
- Updated dependencies [a76168a]
- Updated dependencies [ab692d2]
- Updated dependencies [0c55911]
- Updated dependencies [b27a767]
- Updated dependencies [8cda122]
- Updated dependencies [6fc7f88]
- Updated dependencies [45c8c2c]
- Updated dependencies [55a6182]
- Updated dependencies [ab692d2]
- Updated dependencies [a70ecd2]
- Updated dependencies [db470c8]
- Updated dependencies [9bdbffd]
- Updated dependencies [6c54b78]
- Updated dependencies [691f26d]
- Updated dependencies [4cabdff]
- Updated dependencies [7800a10]
- Updated dependencies [5b98e76]
- Updated dependencies [56b37d5]
- Updated dependencies [edcdb36]
  - @front-commerce/theme-chocolatine@3.3.0
  - @front-commerce/core@3.3.0
  - @front-commerce/remix@3.3.0
  - @front-commerce/compat@3.3.0
  - @front-commerce/adobe-b2b@3.3.0
  - @front-commerce/magento1@3.3.0
  - @front-commerce/magento2@3.3.0
  - @front-commerce/contentful@3.3.0

## 3.2.0

### Minor Changes

- 06a65c153: Replaced hardcoded `<script>` in `root.tsx` with a `<FrontCommerceScripts />` component

  **Migration:** update `root.tsx` with `<FrontCommerceScripts />` from `import { FrontCommerceScripts } from "@front-commerce/remix/react";`

- 7d822f90e: Example/Demo of Contribution mode, to allow turning it on and off
- 90944917c: Magic Button: synchronize Content metadata between the server and the client

### Patch Changes

- 4a633700d: This fixes crashing routes due to namespace exports in re-exported routes
- Updated dependencies [5a8679832]
- Updated dependencies [4a633700d]
- Updated dependencies [06a65c153]
- Updated dependencies [7900d4a72]
- Updated dependencies [826e7d793]
- Updated dependencies [4a76136ff]
- Updated dependencies [50f58b375]
- Updated dependencies [01f03d096]
- Updated dependencies [735da190d]
- Updated dependencies [7f1eaa507]
- Updated dependencies [ef1bab5d5]
- Updated dependencies [9ba40c30f]
- Updated dependencies [e83d8a39b]
- Updated dependencies [24001dc77]
- Updated dependencies [650d1fb57]
- Updated dependencies [cd92a0203]
- Updated dependencies [e06aaeb23]
- Updated dependencies [a0f24ce64]
- Updated dependencies [49ea71090]
- Updated dependencies [f0803104a]
- Updated dependencies [d3f3b9ae7]
- Updated dependencies [397546e00]
- Updated dependencies [90944917c]
- Updated dependencies [6a305be42]
- Updated dependencies [edb37335b]
- Updated dependencies [731c46560]
- Updated dependencies [d680b1466]
  - @front-commerce/contentful@3.2.0
  - @front-commerce/remix@3.2.0
  - @front-commerce/core@3.2.0
  - @front-commerce/adobe-b2b@3.2.0
  - @front-commerce/theme-chocolatine@3.2.0
  - @front-commerce/magento1@3.2.0
  - @front-commerce/magento2@3.2.0
  - @front-commerce/compat@3.2.0

## 3.2.0-alpha.3

### Patch Changes

- Updated dependencies [01f03d096]
- Updated dependencies [7f1eaa507]
- Updated dependencies [731c46560]
  - @front-commerce/theme-chocolatine@3.2.0-alpha.3
  - @front-commerce/magento2@3.2.0-alpha.3
  - @front-commerce/adobe-b2b@3.2.0-alpha.3
  - @front-commerce/compat@3.2.0-alpha.3
  - @front-commerce/contentful@3.2.0-alpha.3
  - @front-commerce/core@3.2.0-alpha.3
  - @front-commerce/magento1@3.2.0-alpha.3
  - @front-commerce/remix@3.2.0-alpha.3

## 3.2.0-alpha.2

### Minor Changes

- 06a65c153: Replaced hardcoded `<script>` in `root.tsx` with a `<FrontCommerceScripts />` component

  **Migration:** update `root.tsx` with `<FrontCommerceScripts />` from `import { FrontCommerceScripts } from "@front-commerce/remix/react";`

- 90944917c: Magic Button: synchronize Content metadata between the server and the client

### Patch Changes

- 4a633700d: This fixes crashing routes due to namespace exports in re-exported routes
- Updated dependencies [4a633700d]
- Updated dependencies [06a65c153]
- Updated dependencies [50f58b375]
- Updated dependencies [735da190d]
- Updated dependencies [e83d8a39b]
- Updated dependencies [cd92a0203]
- Updated dependencies [e06aaeb23]
- Updated dependencies [a0f24ce64]
- Updated dependencies [90944917c]
  - @front-commerce/adobe-b2b@3.2.0-alpha.2
  - @front-commerce/theme-chocolatine@3.2.0-alpha.2
  - @front-commerce/remix@3.2.0-alpha.2
  - @front-commerce/core@3.2.0-alpha.2
  - @front-commerce/magento2@3.2.0-alpha.2
  - @front-commerce/contentful@3.2.0-alpha.2
  - @front-commerce/magento1@3.2.0-alpha.2
  - @front-commerce/compat@3.2.0-alpha.2

## 3.2.0-alpha.1

### Patch Changes

- Updated dependencies [5a8679832]
- Updated dependencies [826e7d793]
- Updated dependencies [4a76136ff]
- Updated dependencies [9ba40c30f]
- Updated dependencies [24001dc77]
- Updated dependencies [49ea71090]
- Updated dependencies [f0803104a]
- Updated dependencies [6a305be42]
- Updated dependencies [edb37335b]
  - @front-commerce/contentful@3.2.0-alpha.1
  - @front-commerce/remix@3.2.0-alpha.1
  - @front-commerce/core@3.2.0-alpha.1
  - @front-commerce/theme-chocolatine@3.2.0-alpha.1
  - @front-commerce/magento1@3.2.0-alpha.1
  - @front-commerce/magento2@3.2.0-alpha.1
  - @front-commerce/adobe-b2b@3.2.0-alpha.1
  - @front-commerce/compat@3.2.0-alpha.1

## 3.2.0-alpha.0

### Patch Changes

- Updated dependencies [7900d4a72]
- Updated dependencies [ef1bab5d5]
- Updated dependencies [650d1fb57]
  - @front-commerce/theme-chocolatine@3.2.0-alpha.0
  - @front-commerce/magento1@3.2.0-alpha.0
  - @front-commerce/remix@3.2.0-alpha.0
  - @front-commerce/adobe-b2b@3.2.0-alpha.0
  - @front-commerce/magento2@3.2.0-alpha.0
  - @front-commerce/compat@3.2.0-alpha.0
  - @front-commerce/core@3.2.0-alpha.0

## 3.1.0

### Minor Changes

- 094dd89b8: Publish the skeleton as a Remix stack

  Install it using: `npx create-remix@latest hello-v3 --template https://new.front-commerce.app/ -y`

- 47104009b: Add `translate` command to cli to be used to extract messages inside an project
- ee4593fd7: Fixes the checkout page's title
- 8a1ff60ec: Remove `i18n-iso-countries` usage by using native `Intl` api
- 4ca3a712e: Implement loading of translations for shop locale

### Patch Changes

- d3c5cc017: Fixes the `dev:server` command to still watch imports inside the `server.ts` but exlcude remix builds from the server watcher.
- dec95e1f5: Fixes the HMR performance by avoiding full server restarts when remix rebuilds, additionaly it passes watchPaths as resolved glob paths to avoid speed up the remix rebuild.
- b7140595e: Fix TSConfig paths loading in userland projects (thanks to `tsconfig-paths` 🙏)

  To prevent `Cannot find module '~/config/xxxx'` issues from `@front-commerce/*` packages when ran after creating a new project.

- 422393a9b: Refactored Login page authentication check and automatic redirection to loader.
- b869ed9d0: This reverses the order of the defined extensions for the `tsconfig.json` which allows overrides. The last extension defined in `front-commerce.config.ts` has the most priority.

  In the following example `magento2Demo` will have the highest priority and will override the `themeChocolatine` extension.

  ```ts
  export default defineConfig({
    extensions: [
      themeChocolatine(),
      magento2(),
      magento2Demo(),
    ],
    ...
  });
  ```

- 7a1ea24ce: Fixed an issue with category sort params not initialized by default.
- Updated dependencies [01ed20baf]
- Updated dependencies [11d0edcd9]
- Updated dependencies [d79bb7d6a]
- Updated dependencies [a21fe7504]
- Updated dependencies [f957a9d11]
- Updated dependencies [7b2d0db76]
- Updated dependencies [0908c1daa]
- Updated dependencies [b7daeefa9]
- Updated dependencies [7ecd5e7e9]
- Updated dependencies [7f59ab32e]
- Updated dependencies [15baeb59f]
- Updated dependencies [5f66c4b93]
- Updated dependencies [1ff7cc719]
- Updated dependencies [950e36d1e]
- Updated dependencies [dd845b8d0]
- Updated dependencies [e405ae21b]
- Updated dependencies [6feffe0b6]
- Updated dependencies [6e69e5151]
- Updated dependencies [b036e06dd]
- Updated dependencies [69db10392]
- Updated dependencies [dec95e1f5]
- Updated dependencies [b8bbf6620]
- Updated dependencies [275428821]
- Updated dependencies [422393a9b]
- Updated dependencies [b869ed9d0]
- Updated dependencies [47104009b]
- Updated dependencies [f04ad5a8f]
- Updated dependencies [a757e1ffe]
- Updated dependencies [0b41ece58]
- Updated dependencies [e8886c39b]
- Updated dependencies [578134818]
- Updated dependencies [05760c75b]
- Updated dependencies [a9e51fdd9]
- Updated dependencies [7d7d3c2ae]
- Updated dependencies [180acb297]
- Updated dependencies [6e8cd469e]
- Updated dependencies [134e4255f]
- Updated dependencies [63366b0ef]
- Updated dependencies [f2b2a9fe6]
- Updated dependencies [8a1ff60ec]
- Updated dependencies [bb58697f5]
- Updated dependencies [0410acea4]
- Updated dependencies [191aba9f1]
- Updated dependencies [ba6ff5df7]
- Updated dependencies [3abf903bc]
- Updated dependencies [4ca3a712e]
- Updated dependencies [f4ef727c0]
  - @front-commerce/remix@3.1.0
  - @front-commerce/theme-chocolatine@3.1.0
  - @front-commerce/adobe-b2b@3.1.0
  - @front-commerce/magento2@3.1.0
  - @front-commerce/core@3.1.0
  - @front-commerce/compat@3.1.0

## 3.1.0-alpha.4

### Patch Changes

- dec95e1f5: Fixes the HMR performance by avoiding full server restarts when remix rebuilds, additionaly it passes watchPaths as resolved glob paths to avoid speed up the remix rebuild.
- Updated dependencies [dec95e1f5]
- Updated dependencies [0b41ece58]
  - @front-commerce/remix@3.1.0-alpha.4
  - @front-commerce/core@3.1.0-alpha.4
  - @front-commerce/adobe-b2b@3.1.0-alpha.4
  - @front-commerce/magento2@3.1.0-alpha.4
  - @front-commerce/theme-chocolatine@3.1.0-alpha.4
  - @front-commerce/compat@3.1.0-alpha.4

## 3.1.0-alpha.3

### Patch Changes

- Updated dependencies [e405ae21b]
- Updated dependencies [a757e1ffe]
- Updated dependencies [a9e51fdd9]
  - @front-commerce/core@3.1.0-alpha.3
  - @front-commerce/compat@3.1.0-alpha.3
  - @front-commerce/theme-chocolatine@3.1.0-alpha.3
  - @front-commerce/magento2@3.1.0-alpha.3
  - @front-commerce/adobe-b2b@3.1.0-alpha.3
  - @front-commerce/remix@3.1.0-alpha.3

## 3.1.0-alpha.2

### Minor Changes

- 47104009b: Add `translate` command to cli to be used to extract messages inside an project
- 8a1ff60ec: Remove `i18n-iso-countries` usage by using native `Intl` api
- 4ca3a712e: Implement loading of translations for shop locale

### Patch Changes

- ee4593fd7: Fixes the checkout page's title
- Updated dependencies [01ed20baf]
- Updated dependencies [11d0edcd9]
- Updated dependencies [d79bb7d6a]
- Updated dependencies [a21fe7504]
- Updated dependencies [f957a9d11]
- Updated dependencies [0908c1daa]
- Updated dependencies [15baeb59f]
- Updated dependencies [1ff7cc719]
- Updated dependencies [950e36d1e]
- Updated dependencies [6feffe0b6]
- Updated dependencies [b036e06dd]
- Updated dependencies [275428821]
- Updated dependencies [47104009b]
- Updated dependencies [f04ad5a8f]
- Updated dependencies [05760c75b]
- Updated dependencies [7d7d3c2ae]
- Updated dependencies [6e8cd469e]
- Updated dependencies [8a1ff60ec]
- Updated dependencies [191aba9f1]
- Updated dependencies [ba6ff5df7]
- Updated dependencies [3abf903bc]
- Updated dependencies [4ca3a712e]
- Updated dependencies [f4ef727c0]
  - @front-commerce/remix@3.1.0-alpha.2
  - @front-commerce/theme-chocolatine@3.1.0-alpha.2
  - @front-commerce/adobe-b2b@3.1.0-alpha.2
  - @front-commerce/magento2@3.1.0-alpha.2
  - @front-commerce/core@3.1.0-alpha.2
  - @front-commerce/compat@3.1.0-alpha.2

## 3.1.0-alpha.1

### Patch Changes

- b7140595e: Fix TSConfig paths loading in userland projects (thanks to `tsconfig-paths` 🙏)

  To prevent `Cannot find module '~/config/xxxx'` issues from `@front-commerce/*` packages when ran after creating a new project.

- b869ed9d0: This reverses the order of the defined extensions for the `tsconfig.json` which allows overrides. The last extension defined in `front-commerce.config.ts` has the most priority.

  In the following example `magento2Demo` will have the highest priority and will override the `themeChocolatine` extension.

  ```ts
  export default defineConfig({
    extensions: [
      themeChocolatine(),
      magento2(),
      magento2Demo(),
    ],
    ...
  });
  ```

- Updated dependencies [7ecd5e7e9]
- Updated dependencies [6e69e5151]
- Updated dependencies [b869ed9d0]
- Updated dependencies [134e4255f]
- Updated dependencies [bb58697f5]
  - @front-commerce/magento2@3.1.0-alpha.1
  - @front-commerce/core@3.1.0-alpha.1
  - @front-commerce/remix@3.1.0-alpha.1
  - @front-commerce/compat@3.1.0-alpha.1
  - @front-commerce/adobe-b2b@3.1.0-alpha.1
  - @front-commerce/theme-chocolatine@3.1.0-alpha.1

## 3.1.0-alpha.0

### Minor Changes

- 094dd89b8: Publish the skeleton as a Remix stack

  Install it using: `npx create-remix@latest hello-v3 --template https://new.front-commerce.app/ -y`

### Patch Changes

- 422393a9b: Refactored Login page authentication check and automatic redirection to loader.
- 7a1ea24ce: Fixed an issue with category sort params not initialized by default.
- Updated dependencies [7b2d0db76]
- Updated dependencies [b7daeefa9]
- Updated dependencies [5f66c4b93]
- Updated dependencies [dd845b8d0]
- Updated dependencies [422393a9b]
- Updated dependencies [e8886c39b]
- Updated dependencies [578134818]
- Updated dependencies [180acb297]
- Updated dependencies [63366b0ef]
  - @front-commerce/theme-chocolatine@3.1.0-alpha.0
  - @front-commerce/remix@3.1.0-alpha.0
  - @front-commerce/core@3.1.0-alpha.0
  - @front-commerce/magento2@3.1.0-alpha.0
  - @front-commerce/compat@3.1.0-alpha.0

## 3.0.0

### Minor Changes

- f7fb56f4d: Initialize the skeleton by running `pnpm dlx create-remix@latest`
- 973569b7f: - Update Remix Stack to version 1.18.1
  - Enable new dev server using the `v2_dev: true` property in `remix.config.js` in skeleton
  - Update `dev:server` command to ignore app directory
- 2ff06db5b: Add a `graphql` playground using `yoga`.
- 1bd9ebf6a: Initialize test related tooling in the Skeleton
- 223344140: Add the `front-commerce` cli to the skeleton

### Patch Changes

- 35a949e79: Updated dependencies
  - update dependency eslint to v8.40.0
  - update dependency @types/react to v18.2.6
  - update dependency @types/react-dom to to v18.2.4
  - update remix to v1.16.0

- 3571d68a5: Update the `server.ts` to use the new Remix Dev Server and support esm with `tsx`
- Updated dependencies [5bdd78d6a]
- Updated dependencies [82ac02e5d]
- Updated dependencies [9c7428340]
- Updated dependencies [7c5691b80]
- Updated dependencies [bda924891]
- Updated dependencies [6d9ecb366]
- Updated dependencies [2917d9ef8]
- Updated dependencies [c4bcef3a9]
- Updated dependencies [973569b7f]
- Updated dependencies [b1ceab08a]
- Updated dependencies [b1ceab08a]
- Updated dependencies [a8fc97a1c]
- Updated dependencies [0ddf6fab4]
- Updated dependencies [2ff06db5b]
- Updated dependencies [b37499946]
- Updated dependencies [d05fecb8c]
- Updated dependencies [85f1cc355]
- Updated dependencies [06e058b6e]
- Updated dependencies [076f72be2]
- Updated dependencies [3373203cd]
- Updated dependencies [6fc060522]
- Updated dependencies [9a69b1ee0]
- Updated dependencies [31ed684fb]
- Updated dependencies [3571d68a5]
- Updated dependencies
- Updated dependencies [0a7b10f3f]
- Updated dependencies [bda924891]
- Updated dependencies [223344140]
- Updated dependencies [d089b98fe]
  - @front-commerce/remix@3.0.0
  - @front-commerce/core@3.0.0
  - @front-commerce/compat@3.0.0
  - @front-commerce/magento2@3.0.0
  - @front-commerce/theme-chocolatine@3.0.0

## 3.0.0-alpha.2

### Minor Changes

- f7fb56f4d: Initialize the skeleton by running `pnpm dlx create-remix@latest`
- 2ff06db5b: Add a `graphql` playground using `yoga`.

### Patch Changes

- 35a949e79: Updated dependencies
  - update dependency eslint to v8.40.0
  - update dependency @types/react to v18.2.6
  - update dependency @types/react-dom to to v18.2.4
  - update remix to v1.16.0
- 3571d68a5: Update the `server.ts` to use the new Remix Dev Server and support esm with `tsx`

## 3.0.0-alpha.1

### Minor Changes

- f7fb56f4d: Initialize the skeleton by running `pnpm dlx create-remix@latest`
