// TODO: FC-2134 : Testing: `root.tsx`, `entry.server.tsx` and `entry.client.tsx` assertions
import { CompatProviderBrowser } from "@front-commerce/compat/CompatProvider";
import {
  FrontCommerceBrowser,
  FrontCommerceScripts,
  type UseDataFunctionReturn,
} from "@front-commerce/remix/react";
import { createRemixStub } from "@remix-run/testing";
import { render, screen } from "@testing-library/react";
import type { PropsWithChildren } from "react";
import Root, { loader } from "../root";
import { createIntl } from "react-intl";

const mockLocale = "en-US";
const mockMessages = {
  acme: "message",
  "pages.Maintenance.seoTitle": "Maintenance Mode",
  "pages.Maintenance.content": "Maintenance Mode",
  "pages.RateLimit.title": "Rate Limit",
  "pages.RateLimit.content": "Rate Limit",
  "modules.PageError.NotFound.title": "Not Found",
  "modules.PageError.NotFound.message1": "Not Found",
};

const mockLoaderData = {
  intl: createIntl({
    locale: mockLocale,
    messages: mockMessages,
  }),
  rootLoaderContext: {
    device: "mockDevice",
    publicConfig: {
      shop: {
        url: "mockUrl",
        locale: mockLocale,
      },
    },
    messages: mockMessages,
    routeErrorMeta: {},
  } satisfies UseDataFunctionReturn<typeof loader>,
};

vi.mock("@front-commerce/remix", async (importActual) => ({
  // eslint-disable-next-line @typescript-eslint/consistent-type-imports
  ...(await importActual<typeof import("@front-commerce/remix")>()),
  FrontCommerceApp: vi.fn().mockImplementation(() => mockLoaderData),
}));

const Providers = ({ children }: PropsWithChildren) => {
  return (
    <>
      <FrontCommerceBrowser>
        <CompatProviderBrowser>
          {/* Welcome to https://example.com */}
          <div>{children}</div>
          <script
            dangerouslySetInnerHTML={{
              __html: `window.__APOLLO_STATE__ = {hello:"world};`,
            }}
          />
        </CompatProviderBrowser>
      </FrontCommerceBrowser>
      {/* // TODO: FC-2134: currently we can't test the Layout directly as the remix stub already has `html` and `head` elements which will cause hydration issues  */}
      <FrontCommerceScripts />
    </>
  );
};

describe("Root", () => {
  afterAll(() => {
    vi.resetAllMocks();
    vi.resetModules();
  });

  it("renders with loader data and includes FrontCommerceScripts and CompatScripts", async () => {
    // Mock your Remix route stub with the loader function returning mockLoaderData

    const RemixStub = createRemixStub([
      {
        path: "/", // Adjust as necessary for your application
        index: true,
        Component: () => (
          <Providers>
            Renders Route
            <Root />
          </Providers>
        ),
        loader: async (...args) => {
          const response = await loader(...args);
          const cloned = response.clone();

          // @ts-expect-error
          globalThis.__remixContext = {
            state: {
              loaderData: {
                root: await cloned.json(),
              },
            },
          };
          return response;
        },
      },
    ]);

    await render(<RemixStub />);

    // Perform assertions to verify the component renders as expected
    // This might include checking for text content, attributes, etc., that depend on the loader data

    // Since `FrontCommerceScripts` and `CompatScripts` affect the global window object, you might also
    // check for the presence of their effects rather than the scripts themselves, if applicable

    // Example assertion (adjust according to what's actually rendered by your component)
    expect(await screen.findByText("Renders Route")).toBeInTheDocument();

    const frontCommerceScript = document.querySelector(
      'script[data-testid="front-commerce-scripts"]',
    );
    expect(frontCommerceScript).toBeInTheDocument();
    expect(frontCommerceScript?.innerHTML).toContain(
      "window.__FRONT_COMMERCE__",
    );

    expect(true).toBe(true);
  });
});
