import { json } from "@front-commerce/remix/node";
import { createRemixStub } from "@remix-run/testing";
import { render, screen, waitFor } from "@testing-library/react";
import HelloWorldRoute from "../../routes/hello-world";

describe("hello-world route", () => {
  it("should render the component with fetched data", async () => {
    // Define your mock data based on the expected GraphQL response structure
    const mockData = {
      shop: {
        url: "https://example.com",
      },
      me: {
        firstname: "John",
      },
      navigationMenu: [
        { id: "1", name: "Category 1", path: "/category-1" },
        { id: "2", name: "Category 2", path: "/category-2" },
        { id: "3", name: "Category 3", path: "/category-3" },
      ],
      title: "Hello World",
    };

    const RemixStub = createRemixStub([
      {
        path: "/", // Adjust the path as necessary
        Component: HelloWorldRoute,
        loader() {
          return json(mockData);
        },
      },
    ]);

    render(<RemixStub />);

    await waitFor(() => {
      expect(screen.getByText(`Hi John 👋`)).toBeInTheDocument();
      expect(
        screen.getByText(`Welcome to https://example.com`),
      ).toBeInTheDocument();
      // Verify one of the navigation menu items is rendered
      expect(screen.getByText("Category 1")).toBeInTheDocument();
    });
  });
});
