import {
  getPublicConfig,
  type AnalyticsConfig,
} from "@front-commerce/core/react";

const getDemoAnalyticsPlugins = () => {
  /**
   * This is example code used in Front-Commerce demos to dynamically load analytics plugins
   * based on configuration from analyticsConfigProvider.
   *
   * Projects can implement this in a more static manner by:
   * - directly configuring the plugins they need without using configuration providers
   * - hardcoding the plugin configurations based on their requirements
   * - or implementing their own dynamic configuration strategy
   *
   * See https://developers.front-commerce.com/docs/advanced/analytics/plugins
   * for more details about analytics configuration in Front-Commerce.
   */
  const publicConfig = getPublicConfig?.() ?? {};
  const plugins: AnalyticsConfig["plugins"] = [];

  if (publicConfig.analytics?.googleAnalytics?.enabled) {
    const measurementIds =
      publicConfig.analytics?.googleAnalytics?.measurementIds ?? [];

    plugins.push({
      name: "google-analytics",
      needConsent: true,
      enabledByDefault: false,
      settings: (authorization) => {
        return {
          measurementIds,
          gtagConfig: {
            anonymize_ip: !authorization,
          },
        };
      },
      script: () => import("@analytics/google-analytics"),
    });
  }

  return plugins;
};

export default {
  analytics: {
    enable: true,
    debug: false,
    serverTracking: {
      enabled: true,
    },
    /**
     * ### Documentation
     * - https://developers.front-commerce.com/docs/advanced/analytics/plugins
     *
     * ### Examples
     * - https://gitlab.blackswift.cloud/front-commerce/examples/analytics
     */
    plugins: getDemoAnalyticsPlugins(),
  } satisfies AnalyticsConfig,
};
