export default {
  defaultMaxBatchSize: 100,
  strategies: [
    // learn more at https://developers.front-commerce.com/docs/3.x/guides/caching-remote-data/configure-caching-strategies
    {
      implementation: "Redis",
      supports: "*",
      config: {
        // see https://github.com/redis/ioredis/blob/main/README.md
        host:
          process.env.FRONT_COMMERCE_CLOUD_REDIS_HOST ||
          process.env.FRONT_COMMERCE_REDIS_HOST ||
          "127.0.0.1",
        port:
          process.env.FRONT_COMMERCE_CLOUD_REDIS_PORT ||
          process.env.FRONT_COMMERCE_REDIS_PORT ||
          6379,
        db: process.env.FRONT_COMMERCE_REDIS_DB || 1,
      },
    },
    // {
    //   implementation: "PerMagentoCustomerGroup",
    //   // Will scope all data from the CatalogPrice DataLoader with the customer group
    //   // (and other relevant price data loaders)
    //   // before they are transmitted to the previous strategy (Redis).
    //   // Other dataLoaders will use Redis storage in a standard fashion.
    //   supports: [
    //     "CatalogPrice",
    //     "CatalogProductChildrenPrice",
    //     "CatalogProductBundlePrice",
    //   ],
    //   config: {
    //     defaultGroupId: 0,
    //   },
    // },
    // {
    //   implementation: "PerMagentoCustomerTaxZone",
    //   supports: [
    //     "CatalogPrice",
    //     "CatalogProductChildrenPrice",
    //     "CatalogProductBundlePrice",
    //   ],
    //   config: {
    //     addressType: "shipping",
    //     defaultTaxZoneKey: "US",
    //   },
    // },
  ],
};
