import { getPublicConfig } from "@front-commerce/core/react";

const isProd = getPublicConfig().environment === "production";

const createPath = (path) => {
  const prefix = isProd ? "demo/prod" : "demo/dev";
  return {
    path: `/${prefix}${path}`,
    source: path,
  };
};

const config = {
  defaultBgColor: "FFFFFF",
  presets: {
    swatch: { width: 26, height: 26, bgColors: [] },
    thumbnail: { width: 50, height: 50, bgColors: [] },
    small: { width: 136, height: 168, bgColors: [] },
    galleryPreview: { width: 136, height: 136, bgColors: [] },
    medium: { width: 474, height: 474, bgColors: [] },
    large: { width: 1100, height: 1100, bgColors: [] },
    newsletter: { width: 1280, height: 242, bgColors: [] },
    carousel: { width: 1280, height: 600, bgColors: [] },
    pushBlock: { width: 284, height: 354, bgColors: [] },
    pushBlockWide: { width: 568, height: 354, bgColors: [] },
    cartPreview: { width: 50, height: 50, bgColors: [] },
    wishlistPreview: { width: 50, height: 50, bgColors: [] },
    zoomable: { width: 1100, height: 1100, bgColors: [], sizes: [2] },
  },
  /** @type {"original"} */
  originalPresetCode: "original",
  twicpics: {
    domain: "https://front-commerce.twic.pics",
    paths: [createPath("/media"), createPath("/images")],
  },
};

export const { defaultBgColor, presets, originalPresetCode } = config;
export default config;
