import {
  ConsoleIntegration,
  AnalyticsIntegration,
} from "@front-commerce/core/server-events/integrations";

export default {
  redis: {
    host:
      process.env.FRONT_COMMERCE_SERVER_EVENT_REDIS_HOST ||
      process.env.FRONT_COMMERCE_CLOUD_REDIS_HOST ||
      process.env.FRONT_COMMERCE_REDIS_HOST ||
      "127.0.0.1",
    port:
      process.env.FRONT_COMMERCE_SERVER_EVENT_REDIS_PORT ||
      process.env.FRONT_COMMERCE_CLOUD_REDIS_PORT ||
      process.env.FRONT_COMMERCE_REDIS_PORT ||
      6379,
  },
  integrations: [
    new ConsoleIntegration(),
    new AnalyticsIntegration("front-commerce"),
  ],
};
