/**
 * By default, Remix will handle hydrating your app on the client for you.
 * You are free to delete this file if you'd like to, but if you ever want it revealed again, you can run `npx remix reveal` ✨
 * For more information, see https://remix.run/docs/en/main/file-conventions/entry.client
 */
import { RemixBrowser } from "@remix-run/react";
import { StrictMode, startTransition } from "react";
import { hydrateRoot } from "react-dom/client";
import {
  FrontCommerceBrowser,
  prepareHydration,
  onRecoverableError,
} from "@front-commerce/remix/react";
import { CompatProviderBrowser } from "@front-commerce/compat/CompatProvider";
import manifest from "virtual:front-commerce/manifest";

// StrictMode causes issues with Apollo Client 2.x (see https://github.com/apollographql/apollo-client/issues/9632), so in compat mode we don't use it
const StrictModeOrNoop = manifest.v2_compat?.useApolloClientQueries
  ? ({ children }: React.PropsWithChildren) => children
  : StrictMode;

const hydrate = async () => {
  hydrateRoot(
    document,
    <StrictModeOrNoop>
      <FrontCommerceBrowser>
        <CompatProviderBrowser>
          <RemixBrowser />
        </CompatProviderBrowser>
      </FrontCommerceBrowser>
    </StrictModeOrNoop>,
    {
      onRecoverableError,
    },
  );
};

startTransition(() => {
  prepareHydration(hydrate);
});
