import { CompatScripts } from "@front-commerce/compat/CompatProvider";
import { FrontCommerceApp } from "@front-commerce/remix";
import { generateMetas, json } from "@front-commerce/remix/node";
import { FrontCommerceScripts } from "@front-commerce/remix/react";
import type {
  LinksFunction,
  LoaderFunctionArgs,
  MetaFunction,
} from "@remix-run/node";
import {
  Links,
  Meta,
  Outlet,
  Scripts,
  ScrollRestoration,
  useNavigation,
} from "@remix-run/react";
import { usePageProgress } from "theme/components/helpers/usePageProgress";
import "theme/main.scss";
import config from "~/config/website";
import { pwaAssetsHead } from "virtual:pwa-assets/head";
import { RootErrorBoundary } from "theme/pages/Error";
import { usePublicConfig } from "@front-commerce/core/react";
import MagicButton from "theme/modules/MagicButton";

export const loader = async ({ context }: LoaderFunctionArgs) => {
  const app = new FrontCommerceApp(context.frontCommerce);

  return json(app.rootLoaderContext);
};

export const shouldRevalidate = () => false;

export const links: LinksFunction = () => {
  return pwaAssetsHead.links;
};

export const meta: MetaFunction = (args) => {
  const metatags = [
    { title: config.defaultTitle },
    { name: "robots", content: "Index,Follow" },
    { name: "description", content: config.defaultDescription },
    { name: "baseUrl", content: args.data?.publicConfig?.shop?.url },
    { name: "theme-color", content: pwaAssetsHead.themeColor?.content },
  ];
  const metas = generateMetas(() => metatags);
  return metas(args);
};

export function Layout({ children }: { children: React.ReactNode }) {
  const publicConfig = usePublicConfig();
  return (
    <html lang="en">
      <head>
        <meta charSet="utf-8" />
        <meta name="viewport" content="width=device-width,initial-scale=1" />
        <Meta />
        <FrontCommerceScripts />
        <Links />
        <link
          rel="manifest"
          crossOrigin="use-credentials"
          href={`${publicConfig.shop.baseUrl}/manifest.webmanifest`}
        />
      </head>
      <body>
        {/* children will be the root Component, ErrorBoundary, or HydrateFallback */}
        {children}
        <MagicButton />
        <ScrollRestoration />
        <Scripts />
        <CompatScripts />
      </body>
    </html>
  );
}
export default function App() {
  const navigation = useNavigation();
  usePageProgress(navigation.state !== "idle");

  return <Outlet />;
}

export const ErrorBoundary = RootErrorBoundary;
