import { createGraphQLModule } from "@front-commerce/core/graphql";

export default createGraphQLModule({
  namespace: "ClickCounter",
  dependencies: ["Front-Commerce/Product"],
  typeDefs: /* GraphQL */ `
    extend type Product {
      clickCounter: Int
    }

    extend type Mutation {
      incrementProductCounter(
        sku: String!
        incrementValue: Int
      ): MutationSuccess!
    }
  `,
  loadRuntime: () => import("./runtime"),
});
