import { createGraphQLRuntime } from "@front-commerce/core/graphql";

const randomWait = async () => {
  await new Promise((resolve) => setTimeout(resolve, Math.random() * 3000));
};

export default createGraphQLRuntime({
  resolvers: {
    Product: {
      clickCounter: (product) => {
        console.log(`click count retrieval for product ${product.sku}`);
        // your own retrieval logic here
        return 1;
      },
    },

    Mutation: {
      incrementProductCounter: async (_root, params) => {
        const { sku, incrementValue } = params;
        console.log(`incrementing counter for product "${sku}"`);
        console.log(`counter + ${incrementValue ?? 1}`);
        // your own increment logic here
        await randomWait();
        return {
          success: true,
        };
      },
    },
  },
});
