import type { DynamicRouteUrlMatcher } from "@front-commerce/core";
import type { ContentfulClientApi } from "contentful";

export default class ContentfulUrlMatcher implements DynamicRouteUrlMatcher {
  constructor(private client: ContentfulClientApi<undefined>) {}

  matchUrl = async (url: string) => {
    const slug = url.startsWith("/") ? url.slice(1) : url;

    const entry = await this.client.getEntries({
      content_type: "page",
      "fields.slug": slug,
      select: ["fields.slug"],
    });

    if (entry.total === 0) {
      return undefined;
    }

    return {
      path: url,
      type: "contentful-cms",
      identifier: slug,
      params: {
        slug,
      },
    };
  };
}
