import * as contentful from "contentful";

// This is a workaround to avoid SSR issues with contentful due to the fact that it isn't an ESM module
// It is optimized in Dev mode, but not during SSR or build time
// @ts-ignore (see above)
const createClient = contentful.createClient ?? contentful.default.createClient;

export const createContentfulClient = (
  contentfulConfig: any,
  isPreview?: boolean,
) => {
  const accessToken = isPreview
    ? contentfulConfig.previewAccessToken
    : contentfulConfig.accessToken;

  return createClient({
    space: contentfulConfig.spaceId,
    accessToken,
    host: isPreview ? "preview.contentful.com" : void 0,
    environment: contentfulConfig.environment,
  });
};
