import { ContentType } from "@front-commerce/contentful";
import gql from "graphql-tag";

const dataFormatter = (contentfulData) => {
  if (!contentfulData) {
    return null;
  }

  return {
    title: contentfulData.pageTitle,
    description: contentfulData.pageDescription,
    index: contentfulData.seoIndex,
    follow: contentfulData.seoFollow,
    updatedAt: contentfulData.sys.publishedAt,
    publishedAt: contentfulData.sys.firstPublishedAt,
  };
};

class SeoMetadata extends ContentType {
  constructor() {
    super("seoMetadata", "SeoMetadata", dataFormatter);
  }

  get contentfulFragment() {
    return gql`
      fragment SeoMetadataFragment on SeoMetadata {
        pageTitle
        pageDescription
        seoIndex
        seoFollow
        sys {
          publishedAt
          firstPublishedAt
        }
      }
    `;
  }
}

export default SeoMetadata;
