import { createGraphQLModule } from "@front-commerce/core/graphql";

export default createGraphQLModule({
  namespace: "Demo/Contentful/CmsPages",
  dependencies: ["Contentful/Core"],
  typeDefs: /* GraphQL */ `
    extend type Query {
      homePage: HomePage
      contactPage: ContentfulPage
      marketingPage(slug: String!): ContentfulPage
      allMarketingPages: [ContentfulPage!]!
    }

    type ContentfulPage
      @storefrontContent(extractorIdentifier: "ContentfulPage") {
      title: String
      slug: String
      seo: SeoMetadata
      content: Wysiwyg
    }

    type HomePage @storefrontContent(extractorIdentifier: "HomePage") {
      title: String
      seo: SeoMetadata
      blocks: [HomePageBlocks]!
      articles: [ContentfulPage]!
    }

    type SeoMetadata {
      title: String
      description: String
      index: Boolean
      follow: Boolean
      updatedAt: String
      publishedAt: String
    }

    union HomePageBlocks = BlockCarousel | BlockCategoryProductsList

    type BlockCarousel
      @storefrontContent(extractorIdentifier: "BlockCarousel") {
      id: String
      slides: [BlockCarouselSlide]
    }

    type BlockCarouselSlide {
      title: String
      text: String
      link: String
      image: String
    }

    type BlockCategoryProductsList
      @storefrontContent(extractorIdentifier: "BlockCategoryProductsList") {
      id: String
      title: String
      categoryId: String
      numberOfProducts: Int
      actionText: String
      actionUrl: String
    }

    type WysiwygContentfulLinkData implements WysiwygNodeData {
      dataId: ID
      url: String
    }
  `,
  loadRuntime: () => import("./runtime"),
});
