import { defineRemixExtension } from "@front-commerce/remix";
import configProvider from "./configProvider";
import cmsPages from "./graphql/cms-pages";
import { createContentfulClient } from "./client";
import UrlMatcher from "./UrlMatcher";
import sitemapFetcher from "./sitemapFetcher";

export default function contentfulDemo() {
  return defineRemixExtension({
    meta: import.meta,
    name: "contentful-demo",
    theme: "example-extensions/contentful-demo/theme",
    graphql: {
      modules: [cmsPages],
    },
    configuration: {
      providers: [configProvider],
    },
    routes: import.meta.url,
    unstable_lifecycleHooks: {
      onServerServicesInit: async (services, request, config, user) => {
        const contentfulConfig = config.contentful;
        const client = createContentfulClient(
          contentfulConfig,
          user.contributionMode.previewEnabled,
        );

        services.DynamicRoutes.registerUrlMatcher(
          "contentful",
          () => new UrlMatcher(client),
        );

        services.Sitemap.registerFetcher("contentful", "Pages", () => {
          return sitemapFetcher(client);
        });
      },
    },
  });
}
