import Home from "theme/pages/Home/ContentfulHome";
import { generateMetas, json } from "@front-commerce/remix/node";
import type { LoaderFunctionArgs, MetaFunction } from "@remix-run/node";
import { FrontCommerceApp } from "@front-commerce/remix";
import { HomePageQueryDocument } from "~/graphql/graphql";
import {
  useLoaderData,
  type UseDataFunctionReturn,
} from "@front-commerce/remix/react";

export const loader = async ({ context }: LoaderFunctionArgs) => {
  const app = new FrontCommerceApp(context.frontCommerce);

  const response = await app.graphql.query(HomePageQueryDocument);

  if (!response.homePage) {
    throw json("Home page not found", {
      status: 404,
    });
  }

  app.services.CacheControl.setCacheable({
    sMaxAge: 60,
    staleWhileRevalidate: 21600,
  });

  return json({ homePage: response.homePage });
};

export const meta: MetaFunction = (args: any) => {
  const data = args.data as UseDataFunctionReturn<typeof loader>;
  const metas = generateMetas(
    () => [{ title: data.homePage.seo?.title || data.homePage.title }],
    "/",
  );
  return metas(args);
};

export default function Index() {
  const data = useLoaderData<typeof loader>();

  return <Home homePage={data.homePage} />;
}
