import ContactPage from "theme/pages/Contact";
import { generateMetas, json } from "@front-commerce/remix/node";
import type { LoaderFunctionArgs, MetaFunction } from "@remix-run/node";
import { FrontCommerceApp } from "@front-commerce/remix";
import { ContactQueryDocument } from "~/graphql/graphql";
import {
  useLoaderData,
  type UseDataFunctionReturn,
} from "@front-commerce/remix/react";

export const loader = async ({ context, params }: LoaderFunctionArgs) => {
  const app = new FrontCommerceApp(context.frontCommerce);

  const response = await app.graphql.query(ContactQueryDocument);

  if (!response.contactPage) {
    throw json("Page not found", {
      status: 404,
    });
  }

  return json({ page: response.contactPage });
};

export const meta: MetaFunction = (args) => {
  const data = args.data as UseDataFunctionReturn<typeof loader>;

  return generateMetas(
    () => [{ title: data.page.title || "Contact Page" }],
    `/contact`,
  )(args);
};

export default function Index() {
  const data = useLoaderData<typeof loader>();

  return <ContactPage page={data.page} />;
}
