import { FrontCommerceApp } from "@front-commerce/remix";
import { createHandle } from "@front-commerce/remix/handle";
import { generateMetas, json } from "@front-commerce/remix/node";
import {
  useDynamicRouteLoaderData,
  type UseDataFunctionReturn,
} from "@front-commerce/remix/react";
import type { LoaderFunctionArgs, MetaFunction } from "@remix-run/node";
import ContentPage from "theme/pages/Content";
import { ContentQueryDocument } from "~/graphql/graphql";

export const loader = async ({ context, params }: LoaderFunctionArgs) => {
  if (!params.slug) {
    throw json("Page not found", {
      status: 404,
    });
  }

  const app = new FrontCommerceApp(context.frontCommerce);

  const response = await app.graphql.query(ContentQueryDocument, {
    slug: params.slug,
  });

  if (!response.marketingPage) {
    throw json("Page not found", {
      status: 404,
    });
  }

  return json({ page: response.marketingPage });
};

export const handle = createHandle({
  sitemapFetcher: "contentful",
  dynamicRoute: {
    type: "contentful-cms",
  },
});

export const meta: MetaFunction = (args) => {
  const data = args.data as UseDataFunctionReturn<typeof loader>;

  return generateMetas(
    () => [
      { title: data.page.seo?.title || data.page.title || "Content Page" },
    ],
    `/content/${data.page.slug}`,
  )(args);
};

export default function Index() {
  const data = useDynamicRouteLoaderData<typeof loader>();

  return <ContentPage page={data.page} />;
}
