import { createSitemapFetcher } from "@front-commerce/core";
import type { ContentfulClientApi } from "contentful";

export default function sitemapFetcher(client: ContentfulClientApi<undefined>) {
  return createSitemapFetcher(async () => {
    const pages = await client.getEntries({
      content_type: "page",
      select: ["fields.slug", "sys.updatedAt"],
    });

    return pages.items
      .filter((page) => page.fields?.slug)
      .map((page) => {
        return {
          route: `/${page.fields.slug}`,
          lastmod: new Date(page.sys.updatedAt),
        };
      });
  });
}
