import { makeContentBlockLibrary } from "@front-commerce/contentful/react";

import {
  BlockCarousel,
  BlockCarouselFragment,
} from "theme/modules/Blocks/BlockCarousel";
import {
  BlockCategoryProductsList,
  BlockCategoryProductsListFragment,
} from "theme/modules/Blocks/BlockCategoryProductsList";

const blockLibrary = makeContentBlockLibrary("HomePageBlocks", [
  {
    component: BlockCarousel, // Full Image
    fragment: BlockCarouselFragment,
  },
  {
    component: BlockCategoryProductsList, // Products Cards
    fragment: BlockCategoryProductsListFragment,
  },
]);

const definitions = blockLibrary.fragmentDefinitions;

export { definitions };

export default blockLibrary.ContentBlock;
