import { H1 } from "theme/components/atoms/Typography/Heading";
import { FormattedMessage } from "react-intl";

import ExplainedCallToAction from "theme/components/organisms/ExplainedCallToAction";
import Stack from "theme/components/atoms/Layout/Stack";
import StorefrontContent from "theme/modules/StorefrontContent";
import Wysiwyg from "theme/modules/Wysiwyg";
import type { ContentfulPage } from "~/graphql/graphql";
import {
  useTrackPage,
  type UseDataFunctionReturn,
} from "@front-commerce/remix/react";
import ContactForm from "theme/modules/Contact/ContactForm/ContactForm";

interface ContactProps {
  page: UseDataFunctionReturn<ContentfulPage>;
}

const Contact = ({ page }: ContactProps) => {
  useTrackPage("Contact");
  return (
    <div className="page-content page-content--simple">
      <div className="container">
        <ExplainedCallToAction
          title={
            <StorefrontContent type={page.__typename} id={page.slug}>
              <H1>{page.title}</H1>
              {page.content && <Wysiwyg content={page.content} />}
            </StorefrontContent>
          }
        >
          <Stack desktopSize="2" mobileSize="4">
            <div className="center">
              <FormattedMessage
                id="pages.Contact.description"
                defaultMessage="Do not hesitate to contact us, we will answer you as soon as possible."
              />
            </div>
            <ContactForm />
          </Stack>
        </ExplainedCallToAction>
      </div>
    </div>
  );
};

export default Contact;
