import StorefrontContent from "theme/modules/StorefrontContent";
import { H1 } from "theme/components/atoms/Typography/Heading";
import Wysiwyg from "theme/modules/Wysiwyg";
import { useTrackPage } from "@front-commerce/remix/react";
import type { ContentfulPage } from "~/graphql/graphql";
import type { UseDataFunctionReturn } from "@front-commerce/remix/react";

interface ContentProps {
  page: Omit<UseDataFunctionReturn<ContentfulPage>, "seo">;
}

const Content = ({ page }: ContentProps) => {
  useTrackPage("Content " + page.title);

  return (
    <StorefrontContent type={page.__typename} id={page.slug} scope="page">
      <div className="page-content page-content--simple">
        <div className="container">
          <H1>{page.title}</H1>
          {page.content && <Wysiwyg content={page.content} />}
        </div>
      </div>
    </StorefrontContent>
  );
};

export default Content;
