import Icon from "theme/components/atoms/Icon";
import Stack from "theme/components/atoms/Layout/Stack";
import { H2, H3 } from "theme/components/atoms/Typography/Heading";
import Link from "theme/components/atoms/Typography/Link";
import { SuccessAlert } from "theme/components/molecules/Alert";
import FeatureList, { Feature } from "theme/components/organisms/FeatureList";
// import PushBlock from "theme/components/organisms/PushBlock/PushBlock";
import Section from "theme/components/organisms/Section";
import Cell from "theme/components/templates/Grid/Cell";
import Grid from "theme/components/templates/Grid/Grid";
import HomePageContentBlocks from "theme/modules/Blocks/HomePageBlocks";
import Newsletter from "theme/modules/Newsletter";
// import FeaturedProducts from "theme/modules/ProductList/FeaturedProducts";
import StorefrontContent from "theme/modules/StorefrontContent";
import { useTrackPage } from "@front-commerce/remix/react";
import type { HomePage } from "~/graphql/graphql";
import { useLocation } from "@remix-run/react";
import type { UseDataFunctionReturn } from "@front-commerce/remix/react";
import { useExtensionComponentMap } from "@front-commerce/core/react";

interface HomeProps {
  homePage: UseDataFunctionReturn<HomePage>;
}

const Home = (props: HomeProps) => {
  useTrackPage("Home");
  const location = useLocation();

  const Recommendations = useExtensionComponentMap("recommendations");

  return (
    <StorefrontContent
      type={props.homePage.__typename}
      id="homePage"
      scope="page"
    >
      <div className="container">
        {location.state && location.state.successMessage && (
          <SuccessAlert>{location.state.successMessage}</SuccessAlert>
        )}
      </div>

      <Stack size="8">
        <Stack size="4" mobileSize="8">
          <HomePageContentBlocks
            content={props.homePage.blocks}
            renderBlock={(blocks) => {
              return (
                <Stack size="4" mobileSize="8">
                  {blocks}
                </Stack>
              );
            }}
          />

          {Recommendations.HomePage && (
            <div className="container">
              <Recommendations.HomePage />
            </div>
          )}
        </Stack>

        <Section title={<H2>Why should you choose us?</H2>}>
          <div className="container">
            <FeatureList>
              <Feature
                appearance="big"
                icon={
                  <Icon size="big" appearance="block" icon="cube" title="" />
                }
                title={"Free Shipping"}
                description="All purchases over $199 are eligible for free shipping via USPS First Class Mail."
              />
              <Feature
                appearance="big-primary"
                icon={
                  <Icon size="big" appearance="block" icon="cash" title="" />
                }
                title={"Easy Payments"}
                description="All payments are processed instantly over a secure payment protocol."
              />
              <Feature
                appearance="big"
                icon={
                  <Icon size="big" appearance="block" icon="lock" title="" />
                }
                title={"Money-Back Guarantee"}
                description="If an item arrived damaged or you've changed your mind, you can send it back for a full refund."
              />
              <Feature
                appearance="big"
                icon={
                  <Icon size="big" appearance="block" icon="star" title="" />
                }
                title={"Finest Quality"}
                description="Designed to last, each of our products has been crafted with the finest materials."
              />
            </FeatureList>
          </div>
        </Section>
        <Section title={<H2>Articles</H2>}>
          <div className="container">
            <Grid>
              {props.homePage.articles.filter(Boolean).map((article) => {
                return (
                  <Cell size="1" key={article.slug}>
                    <Link to={`/${article.slug}`}>
                      <H3>{article.title || article.slug || "No Title"}</H3>
                      {article.seo?.description}
                    </Link>
                  </Cell>
                );
              })}
            </Grid>
          </div>
        </Section>
        <div className="container">
          <Newsletter />
        </div>
      </Stack>
    </StorefrontContent>
  );
};

export default Home;
