import { FrontCommerceApp } from "@front-commerce/remix";
import { redirect } from "@front-commerce/remix/node";
import type { LoaderFunctionArgs, LoaderFunction } from "@remix-run/node";

export const loader: LoaderFunction = async ({
  request,
  context,
}: LoaderFunctionArgs) => {
  const app = new FrontCommerceApp(context.frontCommerce);

  const enabled = new URL(request.url).searchParams.get("enable") === "on";
  app.user.contributionMode.setContributionMode({
    enabled,
  });

  const redirectUrl = new URL(request.referrer || "/", request.url);
  redirectUrl.searchParams.set("t", Date.now().toString()); // Add a timestamp to avoid caching issues
  return redirect(redirectUrl.toString());
};
