import CookieLink from "theme/modules/Cookie/CookieLink";
import { FormattedMessage } from "react-intl";
import { Form } from "@remix-run/react";
import { useIsContributionModeEnabled } from "@front-commerce/core/react";
import Switch from "theme/components/atoms/Switch";

import "theme/layouts/Footer/Legislation.scss";

const Legislation = (props) => (
  <div className="footer-legislation">
    <ul className="footer-legislation__list container">
      <li className="footer-legislation__item">
        <CookieLink />
      </li>
      <li className="footer-legislation__item">
        <FormattedMessage
          id="layouts.Footer.Legislation.copyright"
          defaultMessage="© {year} All rights reserved"
          values={{ year: new Date().getFullYear() }}
        />
      </li>
    </ul>
    <DevToggleContributionMode />
  </div>
);

const DevToggleContributionMode = () => {
  const isContributionModeEnabled = useIsContributionModeEnabled();

  return (
    <Form
      method="GET"
      action="/demo/contribution-mode"
      reloadDocument
      onChange={(e) => {
        e.currentTarget.submit();
      }}
      style={{
        maxWidth: "20em",
        textAlign: "center",
        margin: "0 auto",
        textTransform: "none",
      }}
    >
      <Switch
        name="enable"
        title="Contribution mode (demo)"
        defaultChecked={isContributionModeEnabled}
      />
    </Form>
  );
};

export default Legislation;
