# Custom Algolia Search extension

It provides an example on how to customize the indices used to search for
products, categories,… based on the request. For instance searching in indices
for French content on the French shop while search in indices in English content
on the US shop.

## Setup

### Dependencies

```bash
$ pnpm add @front-commerce/algolia mem
```

### Enable the extension

Tweak your `front-commerce.config.ts` to get something like:

```typescript
import { defineConfig } from "@front-commerce/core/config";
import themeChocolatine from "@front-commerce/theme-chocolatine";
import magento2 from "@front-commerce/magento2";
import algolia from "@front-commerce/algolia";
import customAlgoliaSearch from "./extensions/custom-algolia-search";
import storesConfig from "./app/config/stores";
import cacheConfig from "./app/config/caching";

export default defineConfig({
  extensions: [
    algolia("standalone"),
    customAlgoliaSearch(),
    magento2(storesConfig),
    themeChocolatine(),
  ],
  stores: storesConfig,
  cache: cacheConfig,
  configuration: {
    providers: [],
  },
});
```
