import mem from "memoize";

const fetchRemoteConfiguration = (request) => {
  // eslint-disable-next-line fc-rules/no-orphan-todo
  // TODO here you can implement any logic based on the request to tweak the
  // index prefix. Here we are adding the current shop locale to the index prefix.
  const lang = request.config.shop.locale;
  const indexNamePrefix = request.config.algolia.indexNamePrefix;
  const indexPrefix = `${indexNamePrefix}${lang}_`;

  return {
    algolia: {
      indexPrefix,
    },
  };
};

const ONE_MINUTE = 60 * 1000;
const memoizedFetchRemoteConfiguration = mem(fetchRemoteConfiguration, {
  maxAge: ONE_MINUTE,
  cacheKey: (args) => {
    const request = args[0];
    console.log(request);
    return request.config.currentShopId;
  },
});

export default {
  name: "customAlgolia",
  values: {},
  fetchRemoteConfiguration: memoizedFetchRemoteConfiguration,
};
