import { INVALIDATE_ALL } from "@front-commerce/core/cache";

/**
 * Example of a custom cache strategy that uses the first part of the IP address
 * to scope cache keys.
 */
export default ({ req, strategyConfig }) => {
  let baseIpIdentifier = strategyConfig?.defaultScope ?? "127";
  const ipParts = req.clientIp?.split(".") ?? [];
  if (ipParts.length > 0) {
    baseIpIdentifier = ipParts[0];
  }

  return (previousStrategy) => ({
    createLoader: (scopeKey, keyPrefix, dataLoaderDefaults) => {
      const newPrefix = keyPrefix + `__${baseIpIdentifier}`;
      return previousStrategy.createLoader(
        scopeKey,
        newPrefix,
        dataLoaderDefaults,
      );
    },
    invalidate: (scopeKey, keyPrefix, id) => {
      const newInvalidationPrefix = keyPrefix + `__${INVALIDATE_ALL}`;
      return previousStrategy.invalidate(scopeKey, newInvalidationPrefix, id);
    },
  });
};
