import { defineExtension } from "@front-commerce/core";
import { registerStrategyImplementation } from "@front-commerce/core/cache";

import perIPAddressStrategy from "./cache/perIPAddressStrategy";

// In the current state of Front-Commerce, the custom cache strategy
// must be registered at the root of the extension.
// Strategies are global and don't yet have a final core Service API for their registration.
registerStrategyImplementation("PerIPAddress", perIPAddressStrategy);

export default () => {
  return defineExtension({
    name: "custom-cache-strategy",
    meta: import.meta,
  });
};
