import { defineRemixExtension } from "@front-commerce/remix";

export default function customFeatures() {
  return defineRemixExtension({
    meta: import.meta,
    name: "custom-features",
    routes: import.meta.url,
    theme: "example-extensions/custom-features/theme",
    unstable_lifecycleHooks: {
      onFeaturesInit: (hooks) => {
        hooks.registerFeature("example", {
          ui: {
            componentsMap: {
              Heading: new URL("theme/components/Heading.tsx", import.meta.url),
              Footer: new URL("theme/components/Footer.tsx", import.meta.url),
            },
          },
        });

        hooks.registerFeature("example", {
          ui: {
            componentsMap: {
              Footer: null, // example to disable the Footer component
            },
          },
        });
      },
    },
  });
}
