/**
 * Loader Errors:
 * 1. throws an unknown ResponseError in loader
 * 2. throws a known ResponseError in loader
 * 3. throws an Error in loader
 * 4. throws an unknown error in loader
 */
export const loaderErrors = [
  {
    path: "/error/loader/known-response-not-found",
    name: "known - Not Found",
    error: () => {
      throw new Response("", { status: 404 });
    },
  },
  {
    path: "/error/loader/unknown-response",
    name: "unknown - Server Error",
    error: () => {
      throw new Response("Unknown response", { status: 500 });
    },
  },
  {
    path: "/error/loader/unknown-response-teapot",
    name: "unknown - Teapot",
    error: () => {
      throw new Response("", { status: 418 });
    },
  },
  {
    path: "/error/loader/unknown-throw-error",
    name: "unknown - Throw Error",
    error: () => {
      throw new Error("This is an Error instance");
    },
  },
  {
    path: "/error/loader/unknown-throw-string",
    name: "unknown - Throw String",
    error: () => {
      throw "This is an unknown error";
    },
  },
];

/**
 * Component Errors:
 * 1. throws an Error in a component
 * 2. throws an unknown error in a component
 */
export const componentErrors = [
  {
    path: "/error/component/error",
    name: "unknown - Throw Error",
    error: () => {
      throw new Error("This is an Error instance");
    },
  },
  {
    path: "/error/component/unknown-error",
    name: "unknown - Throw String",
    error: () => {
      throw "This is an unknown error";
    },
  },
];
