import { defineRemixExtension } from "@front-commerce/remix";
import path from "node:path";

export default function faqDemo() {
  const basePath = "example-extensions/error-boundary-demo";

  return defineRemixExtension({
    meta: import.meta,
    name: "error-boundary-demo",
    theme: path.join(basePath, "theme"),
    routes: import.meta.url,

    unstable_lifecycleHooks: {
      onFeaturesInit: (hooks) => {
        hooks.registerFeature("root-error-meta", {
          config: {
            messages: () => {
              return (intl) => ({
                418: {
                  title: "Custom - Teapot",
                  description: "I'm a teapot",
                },
                500: {
                  title: "Custom - Server Error",
                  description: "This is a custom server error",
                },
              });
            },
          },
        });
      },
    },
  });
}
