import { loaderErrors, componentErrors } from "../errors";
import { useLocation } from "@remix-run/react";
import { type LoaderFunctionArgs } from "@remix-run/node";

export const loader = ({ request }: LoaderFunctionArgs) => {
  const url = new URL(request.url);
  const errorType = loaderErrors.find((error) => error.path === url.pathname);

  if (errorType) {
    errorType.error();
  }

  return null;
};

export default function AcmeErrorPage() {
  const { pathname } = useLocation();

  const errorType = componentErrors.find((error) => error.path === pathname);

  if (errorType) {
    errorType.error();
  }

  return <div>Demo Error Page</div>;
}
