import { LayoutErrorBoundary } from "theme/pages/Error";
import { Outlet } from "@remix-run/react";
import type { PropsWithChildren } from "react";
import { loaderErrors, componentErrors } from "../errors";
import SimpleLayout from "theme/layouts/SimpleLayout";
import LinkList from "theme/components/molecules/LinkList";

const Layout = (props: PropsWithChildren) => {
  return (
    <SimpleLayout>
      <div className="container">
        <LinkList title="Loader Errors" list={loaderErrors} />
        <LinkList title="Component Errors" list={componentErrors} />

        {props.children}
      </div>
    </SimpleLayout>
  );
};

export default function AcmeLayout() {
  return (
    <Layout>
      <Outlet />
    </Layout>
  );
}

export function ErrorBoundary() {
  return (
    <Layout>
      <div
        style={{
          border: "1px dashed red",
          padding: "1rem",
          borderRadius: "0.5rem",
        }}
      >
        <LayoutErrorBoundary />
      </div>
    </Layout>
  );
}
