import { json } from "@front-commerce/remix/node";
import { useLoaderData } from "@front-commerce/remix/react";
import { createRemixStub } from "@remix-run/testing";
import { render, screen, waitFor } from "@testing-library/react";
import Component from "theme/modules/Faq/FaqLayout";
import { IntlProvider } from "react-intl";
import { type FaqQueryQuery } from "~/graphql/graphql";

it("should render a Faq Page", async () => {
  const mockData = {
    faq: [
      {
        slug: "lorem",
        question: "lorem",
        answer: "lorem",
      },
      {
        slug: "ipsum",
        question: "ipsum",
        answer: "ipsum",
      },
    ] satisfies FaqQueryQuery["faq"],
  };

  const FaqLayout = () => {
    const data = useLoaderData<typeof mockData>();
    return (
      <IntlProvider locale="en" messages={{}}>
        <Component faq={data.faq} />
      </IntlProvider>
    );
  };

  const RemixStub = createRemixStub([
    {
      path: "/",
      Component: FaqLayout,
      loader() {
        return json(mockData);
      },
    },
  ]);

  render(<RemixStub />);

  await waitFor(async () => {
    await screen.findByText("lorem");
    await screen.findByText("ipsum");
  });
});
