import FAQRuntime from "../runtime";

describe("Test FAQ Runtime", () => {
  test("should load runtime", () => {
    expect(FAQRuntime).toBeDefined();
  });
  describe("Queries", () => {
    test("should load all entries", async () => {
      const data = await FAQRuntime.resolvers.Query.faq();
      expect(data).toBeDefined();
      expect(data.length).toEqual(2);
    });
    test("should load a single entry", async () => {
      const data = await FAQRuntime.resolvers.Query.faqEntry(undefined, {
        input: { slug: "livraison" },
      });
      expect(data).toMatchInlineSnapshot(`
        {
          "answer": "Les expéditions sont faites sous 48h. Compter ensuite entre 2 et 3 jours de livraison.",
          "question": "Sous quel délais puis-je espérer ma livraison ?",
          "slug": "livraison",
        }
      `);
    });
  });
  describe("Mutations", () => {
    test("Can vote on an entry", async () => {
      const data = await FAQRuntime.resolvers.Mutation.voteIsFaqUseful(
        undefined,
        {
          input: { slug: "livraison", isFaqUseful: true },
        },
      );
      expect(data).toMatchInlineSnapshot(`
        {
          "success": true,
        }
      `);
    });
  });
});
