import { createGraphQLModule } from "@front-commerce/core/graphql";

export default createGraphQLModule({
  namespace: "Faq/Core",
  typeDefs: /* GraphQL */ `
    extend type Query {
      "Returns all the available faq entries"
      faq: [FaqEntry]
      faqEntry(input: FaqEntryInput): FaqEntry
    }

    input FaqEntryInput {
      slug: Slug
    }

    type FaqEntry {
      slug: Slug
      question: String
      answer: String
    }

    input FaqEntryVoteInput {
      slug: Slug!
      isFaqUseful: Boolean!
    }

    extend type Mutation {
      voteIsFaqUseful(input: FaqEntryVoteInput): MutationSuccess
    }
  `,
  scalars: {
    Slug: "string",
  },
  loadRuntime: () => import("./runtime"),
});
