import { createGraphQLRuntime } from "@front-commerce/core/graphql";
import { api } from "example-extensions/faq-demo/api";

const defer = <T extends Function>(fn: T) => {
  const randomDelay = Math.random() * 2000 + 500;

  return new Promise((resolve, reject) => {
    setTimeout(() => {
      try {
        resolve(fn());
      } catch (error) {
        reject(error);
      }
    }, randomDelay);
  });
};

export default createGraphQLRuntime({
  resolvers: {
    Mutation: {
      voteIsFaqUseful: (
        _,
        args: { input: { slug: string; isFaqUseful: boolean } },
      ) => {
        return defer(() => ({
          success: true,
        }));
      },
    },
    Query: {
      faq: () => {
        return defer(() => api.getFaqs());
      },
      faqEntry: (
        _,
        args: {
          input: { slug: string };
        },
      ) => {
        return defer(() => api.getFaqBySlug(args.input.slug));
      },
    },
  },
});
