import { defineRemixExtension } from "@front-commerce/remix";
import path from "path";
import faqModule from "./graphql";
import sitemapFetcher from "./sitemapFetcher";

export default function faqDemo() {
  const basePath = "example-extensions/faq-demo";

  return defineRemixExtension({
    meta: import.meta,
    name: "faq-demo",
    graphql: {
      modules: [faqModule],
    },
    translations: `${basePath}/lang`,
    theme: path.join(basePath, "theme"),
    routes: import.meta.url,
    unstable_lifecycleHooks: {
      onServerServicesInit: async (services) => {
        // This hook is called when the server services are initialized.

        services.Sitemap.registerFetcher("faq", "faq-page", () => {
          return sitemapFetcher;
        });
      },
    },
  });
}
