import { FrontCommerceApp } from "@front-commerce/remix";
import { generateMetas, json } from "@front-commerce/remix/node";
import {
  useLoaderData,
  type UseDataFunctionReturn,
} from "@front-commerce/remix/react";
import type { LoaderFunctionArgs, MetaArgs } from "@remix-run/node";
import Faq from "theme/Pages/Faq";
import { FaqQueryDocument } from "~/graphql/graphql";
import FaqLayout from "theme/modules/Faq/FaqLayout";

export const loader = async ({ context }: LoaderFunctionArgs) => {
  const app = new FrontCommerceApp(context.frontCommerce);
  const response = await app.graphql.query(FaqQueryDocument);

  return json({
    faq: response.faq,
    seo: {
      title: app.intl.formatMessage({
        id: "pages.Faq.title",
        defaultMessage: "Frequently Asked Questions",
      }),
    },
  });
};

export const meta = (args: MetaArgs) => {
  const data = args.data as UseDataFunctionReturn<typeof loader>;

  return generateMetas(() => [{ title: data.seo?.title }])(args);
};

export default function Component() {
  const { faq } = useLoaderData<typeof loader>();

  if (!faq?.length) {
    return <Faq />;
  }

  return <FaqLayout faq={faq} />;
}
