import { ServerEvent } from "@front-commerce/core/events";

const QuestionVotedEventName = "QuestionVotedEvent";

// This is the payload data that we want to gather for the event
type QuestionVotedEventPayload = {
  questionSlug: string;
  upvote: boolean;
};

// We define an event class that extends the ServerEvent class
// This class will handle data to be pushed to the server event pipeline
export default class QuestionVotedEvent extends ServerEvent<QuestionVotedEventPayload> {
  static event_type = QuestionVotedEventName;

  // We define the constructor for our event
  // It will call the super constructor (constructor of ServerEvent)
  // See https://developers.front-commerce.com/docs/3.x/api-reference/front-commerce-core/ServerEvent#arguments
  constructor(questionSlug: string, upvote: boolean, shopId: string) {
    super(
      QuestionVotedEventName,
      new Date(),
      { questionSlug, upvote },
      // This are the event metadata, they are relative to the event
      // but don't contain event data, here we collect the shopId
      // to determine on which shop the question has been voted
      { shopId },
    );
  }
}
