import { createSitemapFetcher } from "@front-commerce/core";
import { api } from "./api";

export default createSitemapFetcher(async () => {
  const entries = await api.getFaqs();

  return entries.map((entry) => {
    return {
      route: `/faq/${entry.slug}`,
      lastmod: new Date(), // this would usually be the last modified date of the entry
      priority: 0.5,
      images: [],
      data: entry,
    };
  });
});
