import FaqEntry from "theme/modules/Faq/FaqEntry";
import FaqEntryQuery from "./FaqEntryQuery.gql";

const FaqEntryPage = (props) => {
  return <FaqEntry entry={props.entry} />;
};

export default compose(
  graphql(FaqEntryQuery, {
    props: ({ data }) => ({
      loading: data.loading,
      error: !data.loading && data.error,
      entry: !data.loading && data.faqEntry,
    }),
    options: (props) => ({
      variables: {
        input: {
          slug: props.match.params.slug,
        },
      },
    }),
  }),
  Loadable((props) => !props.loading),
)(FaqEntryPage);
