import { useEffect, useState } from "react";
import { IconButton } from "theme/components/atoms/Button";
import { BodyFade } from "theme/components/atoms/Typography/Body";

interface CopyButtonProps {
  title: string;
  getValue: () => string;
}

const CopyButton = ({ title, getValue }: CopyButtonProps) => {
  const [copied, setCopied] = useState(false);

  useEffect(() => {
    if (!copied) {
      return;
    }
    const timeout = setTimeout(() => {
      setCopied(false);
    }, 2000);

    return () => {
      clearTimeout(timeout);
    };
  }, [copied]);

  const handleClick = (e) => {
    e.stopPropagation();

    try {
      doCopy();
      navigator.share({
        title,
        url: getValue(),
      });
      setCopied(true);
    } catch {
      doCopy();
    }
  };

  const doCopy = () => {
    const text = getValue();
    try {
      navigator.clipboard.writeText(text).then(() => setCopied(true));
    } catch (error) {
      console.error("Could not copy text: ", error);
    }
  };

  return (
    <div style={{ display: "flex", alignItems: "center" }}>
      <IconButton
        icon="paper"
        iconSize="default"
        title={`Get permalink for ${title}`}
        onClick={handleClick}
      />
      {copied && <BodyFade> Copied!</BodyFade>}
    </div>
  );
};

export default CopyButton;
