import { act, fireEvent, render, screen } from "@testing-library/react";
import CopyButton from "../CopyButton";

describe("CopyButton", () => {
  beforeEach(() => {
    Object.assign(navigator, {
      clipboard: {
        writeText: vi.fn().mockResolvedValue(void 0), // Assuming successful clipboard write
      },
    });
  });

  it("should render the CopyButton", () => {
    render(<CopyButton title="test" getValue={() => "test"} />);

    expect(screen.getByText("Get permalink for test")).toBeInTheDocument();
  });

  it("should allow to copy text", async () => {
    render(<CopyButton title="test" getValue={() => "Test value"} />);

    const button = screen.getByRole("button");

    await act(() => {
      fireEvent.click(button);
    });

    expect(navigator.clipboard.writeText).toHaveBeenCalledWith("Test value");
    screen.getByText("Copied!");
  });
});
