import { FormattedMessage } from "react-intl";
import LinkList from "theme/components/molecules/LinkList";
import ErrorBoundary from "theme/components/helpers/ErrorBoundary";
import {
  contactFooterLinks,
  userAccountFooterLinks,
} from "theme/layouts/Footer/footerLinkLists";
import Brand from "theme/layouts/Footer/Brand";
import type { HeaderQueryQuery } from "~/graphql/graphql";

import "theme/layouts/Footer/BottomBar.scss";

type NavigationMenu = HeaderQueryQuery["navigationMenu"];
type BottomBarProps = {
  navigationMenu: NavigationMenu;
};

const extendedContactFooterLinks = [
  {
    name: (
      <FormattedMessage id="layouts.Footer.Links.faq" defaultMessage="FAQ" />
    ),
    path: "/faq",
  },
  ...contactFooterLinks.links,
];

const BottomBar = (props: BottomBarProps) => (
  <div className="bottombar">
    <div className="container bottombar__wrapper">
      <div className="bottombar__aside">
        <Brand />
      </div>
      <div className="bottombar__links">
        <div className="bottombar__list">
          <LinkList
            title={userAccountFooterLinks.title}
            list={userAccountFooterLinks.links}
          />
        </div>
        <div className="bottombar__list">
          <ErrorBoundary>
            {({ hasError }) =>
              hasError ? null : (
                <LinkList
                  title={
                    <FormattedMessage
                      id="layouts.Footer.categories"
                      defaultMessage="Categories"
                    />
                  }
                  list={props.navigationMenu}
                />
              )
            }
          </ErrorBoundary>
        </div>
        <div className="bottombar__list">
          <LinkList
            title={contactFooterLinks.title}
            list={extendedContactFooterLinks}
          />
        </div>
      </div>
    </div>
  </div>
);

export default BottomBar;
