import { FormattedMessage } from "react-intl";
import type { FaqEntryQueryQuery } from "~/graphql/graphql";
import FaqVote from "./FaqVote";
import CopyButton from "theme/components/atoms/CopyButton";

type FaqEntryProps = {
  entry: FaqEntryQueryQuery["faqEntry"];
};

const FaqEntry = ({ entry }: FaqEntryProps) => {
  if (!entry) {
    return (
      <FormattedMessage
        id="pages.Faq.notFound"
        defaultMessage="Couldn't find your question?"
      />
    );
  }

  return (
    <div>
      {entry.answer}
      <div style={{ display: "flex", justifyContent: "space-between" }}>
        <FaqVote />
        <CopyButton
          title={entry.question}
          getValue={() => `${window.location.origin}/faq/${entry.slug}`}
        />
      </div>
    </div>
  );
};

export default FaqEntry;
